/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef composeIM_H
#define composeIM_H

#include <X11/Xlib.h>
#define XIMP_40
#include "XIMProto.h"
#include "XimpIm.h"

#include "commonIM.h"

#define	COMPOSE_FILE	"Compose"

typedef enum {
  NoAction,
  SwitchTo,
  NextPage,
  PrevPage,
  TopPage,
  LastPage,
  NextCand,
  PrevCand,
  UpCand,
  DownCand,
  SelectCand,
  DoLookup,
  DoConv
} ActionType;

typedef struct _DefTree {
  struct _DefTree *next;	/* another Key definition */
  struct _DefTree *succession;	/* successive Key Sequence */
				/* Key definitions */
  unsigned         modifier_mask;
  unsigned         modifier;
  KeySym           keysym;	/* leaf only */
  int              keycode;	/* leaf only */
  char            *mb;
  KeySym keysym_return;
  ActionType	     action;
  char		*target_name;	/* not NULL if "Change State" */
  struct _LocalIMState	*target;
} DefTree;

typedef enum {
  ComposeState,
  CodeInputState,
  LookupState,			/* Table Input */
  RemoteIMState			/* Remote IM State */
} StateType;

typedef enum {
  HEX,
  OCTET
} InputType;

typedef struct _LuRange {
  char	RangeName[80];
  int	start_range;
  int	end_range;
} LuRange;

typedef struct _AttribList {
  union {
    struct {
      int	max_input_len;
      InputType type_of_input;
    } CIstruct;
    struct {
      LuRange	*range;
      int	nrange;
      int	num_of_rows;
      int	num_of_cols;
      int	num_of_cands;
      char   *title;
    } LUstruct;
  } _attr_u;
} StateAttrib;

#define SET_KEYCODEINFO(s) ((s)->use_keycodeinfo = True)
#define USE_KEYCODEINFO(s) ((s)->use_keycodeinfo == True)

/* Macros for struct DefTreeMap and LocalIMStateMap */
#define BCF_HDR_SIZE			72
#define BCF_HDR_SIGNATURE		0xffff
#define BCF_HDR_PLATFORM_MSB		0x0000
#define BCF_HDR_PLATFORM_LSB		0x0101
#define BCF_HDR_PLATFORM_UNKNOWN	0x0202
#define BCF_HDR_VERSION			0x0100
#define BCF_HDR_VENDER_STRING		"Sun Microsystems, Inc."
#define BCF_HDR_VENDER_STRING_LEN	64

#define BCF_STATE_SIZE		    3
#define BCF_STATE_PTR(b)	    (CARD32 *)((CARD8 *)b + BCF_HDR_SIZE)
#define BCF_STATE_LENGTH(p)	    (*(CARD32 *)p)
#define BCF_STATE_NAME(p, i)	    (*((CARD32 *)p + BCF_STATE_SIZE * (i-1) + 1))
#define BCF_STATE_USE_KEYCODE(p, i) (*((CARD32 *)p + BCF_STATE_SIZE * (i-1) + 2))
#define BCF_STATE_PARSER(p, i)	    (*((CARD32 *)p + BCF_STATE_SIZE * (i-1) + 3))

#define BCF_DEF_SIZE		    9
#define BCF_DEF_PTR(b)		    (BCF_STATE_PTR(b) + 1 + BCF_STATE_SIZE * BCF_STATE_LENGTH(BCF_STATE_PTR(b)))
#define BCF_DEF_LENGTH(p)	    (*(CARD32 *)p)
#define BCF_DEF_NEXT(p, i)	    (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 1))
#define BCF_DEF_SUCCESSION(p, i)    (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 2))
#define BCF_DEF_MODIFIER_MASK(p, i) (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 3))
#define BCF_DEF_MODIFIER(p, i)	    (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 4))
#define BCF_DEF_KEYSYM(p, i)	    (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 5))
#define BCF_DEF_KEYCODE(p, i)	    (*((INT32 *)p + BCF_DEF_SIZE * (i-1) + 6))
#define BCF_DEF_MB(p, i)	    (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 7))
#define BCF_DEF_KEYSYM_RETURN(p, i) (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 8))
#define BCF_DEF_TARGET(p, i)	    (*((CARD32 *)p + BCF_DEF_SIZE * (i-1) + 9))

#define BCF_STR_PTR(b)		(CARD8 *)(BCF_DEF_PTR(b) + 1 + BCF_DEF_SIZE * BCF_DEF_LENGTH(BCF_DEF_PTR(b)))
#define BCF_STR_LENGTH(p)	(*(CARD32 *)p)
#define BCF_STR_STRING(p, i)	(char *)((CARD8 *)p + i + 3)

typedef struct _LocalIMState {
    char		   *name;
    char 		   *language;	
    Bool		   use_keycodeinfo;
    DefTree	   	   *parser;
    StateAttrib            *attr;
    Bool                   attrflag;
    Bool                   actionflag;
    StateType              type; 
   struct _LocalIMState   *next;
} LocalIMState;

/* private XIM data for ComposeIM */
typedef struct _XIMComposeIMRec {
  XIC		current_ic;
  LocalIMState	*top_state;
  Bool		use_binary_table; /* True if use binary table */
  void		*map_addr;	/* for binary table */
  size_t	map_len;	/* for binary table */
  CARD32	*state_addr;	/* for binary table */
  CARD32	*def_addr;	/* for binary table */
  CARD8		*str_addr;	/* for binary table */

  XIMMethods	switch_methods;
} XIMComposeIMRec;

/*
 * IC dependent data struction 
 */

/* private XIC data for ComposeIM */
typedef struct _XICComposeIMRec {
  LocalIMState	*imstate;
  DefTree	*context;
  DefTree	*composed;
  void		*status_ext;
  void		*preedit_ext;
  void		*lookup_ext;
  void		*table_ext;
  XICMethods	switch_methods;
} XICComposeIMRec;

extern Status COMPOSE_OpenIM_SWITCH(XIM xim, XLCd lcd);
extern Status COMPOSE_CreateIC_SWITCH(XIC xic, XIMArg *arg);
extern Bool Ximp_Local_KeyFilter(Display *d, Window w,
				 XEvent *ev, XPointer client_data);

extern XICMethods get_local_ic_methods();

#endif
