/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef _IM_KEYMAP_H
#define _IM_KEYMAP_H

#define _SUN_KEYBOARD

#ifdef _SUN_KEYBOARD

#define	IMSunXK_F36		0x1005FF10	/* Labeled F11 */
#define	IMSunXK_F37		0x1005FF11	/* Labeled F12 */
#define IMSunXK_PageUp		0x0000FF55 	/* Same as IMXK_Prior */
#define IMSunXK_PageDown	0x0000FF56	/* Same as IMXK_Next */
#define IMSunXK_Compose		0x0000FF20	/* Same as IMXK_Multi_key */
#define IMSunXK_AltGraph	0x0000FF7E	/* Same as IMXK_Mode_switch */

#else

#define	IMSunXK_F36		0x1005FF10	/* Labeled F11 */
#define	IMSunXK_F37		0x1005FF11	/* Labeled F12 */
#define IMSunXK_PageUp		0xFF55 		/* Same as IMXK_Prior */
#define IMSunXK_PageDown	0xFF56		/* Same as IMXK_Next */
#define IMSunXK_Compose		0xFF20		/* Same as IMXK_Multi_key */
#define IMSunXK_AltGraph	0x0000FF7E	/* Same as IMXK_Mode_switch */

#endif   /* End of _SUN_KEYBOARD */


#define IMVXK_QUOTER            0x27            /* Defined by MXL!!! */
#define IMXK_REDRAW_INTERNAL    0xEEEE          /* Pesudo keysym Defined by MXL!!! */
#define IMXK_QUIT_PYIM          0xDDDD		/* Quit PinYin Input Method. Defined by MXL!!!*/
#define IMXK_ALT_QP_SP          0xCCCC		/* Switch Bewteen QuanPin and ShuangPin. Defined by MXL!!! */
#define SUN_NUM_KEYSYM          5
#define IMXK_MOUSEPREV          0xBBBB          /* Mouse Press to scroll to prev page. Defined by MXL!!! */
#define IMXK_MOUSENEXT          0xAAAA          /* Mouse Press to scroll to next page. Defined by MXL!!! */

#define IMXK_Mode_switch	0xFF7E	/* Character set switch */
#define IMXK_BackSpace		0xFF08	/* back space, back char */
#define IMXK_Tab		0xFF09
#define IMXK_Linefeed		0xFF0A	/* Linefeed, LF */
#define IMXK_Clear		0xFF0B
#define IMXK_Return		0xFF0D	/* Return, enter */
#define IMXK_Pause		0xFF13	/* Pause, hold */
#define IMXK_Scroll_Lock	0xFF14
#define IMXK_Sys_Req		0xFF15
#define IMXK_Escape		0xFF1B
#define IMXK_Delete		0xFFFF	/* Delete, rubout */
#define IMXK_Multi_key		0xFF20  /* Multi-key character compose */

#define IMXK_Home		0xFF50
#define IMXK_Left		0xFF51	/* Move left, left arrow */
#define IMXK_Up			0xFF52	/* Move up, up arrow */
#define IMXK_Right		0xFF53	/* Move right, right arrow */
#define IMXK_Down		0xFF54	/* Move down, down arrow */
#define IMXK_Prior		0xFF55	/* Prior, previous */
#define IMXK_Page_Up		0xFF55
#define IMXK_Next		0xFF56	/* Next */
#define IMXK_Page_Down		0xFF56
#define IMXK_End		0xFF57	/* EOL */
#define IMXK_Begin		0xFF58	/* BOL */

#define IMXK_KP_Space		0xFF80	/* space */
#define IMXK_KP_Tab		0xFF89
#define IMXK_KP_Enter		0xFF8D	/* enter */
#define IMXK_KP_F1		0xFF91	/* PF1, KP_A, ... */
#define IMXK_KP_F2		0xFF92
#define IMXK_KP_F3		0xFF93
#define IMXK_KP_F4		0xFF94
#define IMXK_KP_Home		0xFF95
#define IMXK_KP_Left		0xFF96
#define IMXK_KP_Up		0xFF97
#define IMXK_KP_Right		0xFF98
#define IMXK_KP_Down		0xFF99
#define IMXK_KP_Prior		0xFF9A
#define IMXK_KP_Page_Up		0xFF9A
#define IMXK_KP_Next		0xFF9B
#define IMXK_KP_Page_Down	0xFF9B
#define IMXK_KP_End		0xFF9C
#define IMXK_KP_Begin		0xFF9D
#define IMXK_KP_Insert		0xFF9E
#define IMXK_KP_Delete		0xFF9F
#define IMXK_KP_Equal		0xFFBD	/* equals */
#define IMXK_KP_Multiply	0xFFAA
#define IMXK_KP_Add		0xFFAB
#define IMXK_KP_Separator	0xFFAC	/* separator, often comma */
#define IMXK_KP_Subtract	0xFFAD
#define IMXK_KP_Decimal		0xFFAE
#define IMXK_KP_Divide		0xFFAF

#define IMXK_KP_0		0xFFB0
#define IMXK_KP_1		0xFFB1
#define IMXK_KP_2		0xFFB2
#define IMXK_KP_3		0xFFB3
#define IMXK_KP_4		0xFFB4
#define IMXK_KP_5		0xFFB5
#define IMXK_KP_6		0xFFB6
#define IMXK_KP_7		0xFFB7
#define IMXK_KP_8		0xFFB8
#define IMXK_KP_9		0xFFB9


/*
** Auxilliary Functions; note the duplicate definitions for left and right
** function keys;  Sun keyboards and a few other manufactures have such
** function key groups on the left and/or right sides of the keyboard.
** We've not found a keyboard with more than 35 function keys total.
*/
#define IMXK_F1			0xFFBE
#define IMXK_F2			0xFFBF
#define IMXK_F3			0xFFC0
#define IMXK_F4			0xFFC1
#define IMXK_F5			0xFFC2
#define IMXK_F6			0xFFC3
#define IMXK_F7			0xFFC4
#define IMXK_F8			0xFFC5
#define IMXK_F9			0xFFC6
#define IMXK_F10		0xFFC7
#define IMXK_F11		0xFFC8
#define IMXK_L1			0xFFC8
#define IMXK_F12		0xFFC9
#define IMXK_L2			0xFFC9
#define IMXK_F13		0xFFCA
#define IMXK_L3			0xFFCA
#define IMXK_F14		0xFFCB
#define IMXK_L4			0xFFCB
#define IMXK_F15		0xFFCC
#define IMXK_L5			0xFFCC
#define IMXK_F16		0xFFCD
#define IMXK_L6			0xFFCD
#define IMXK_F17		0xFFCE
#define IMXK_L7			0xFFCE
#define IMXK_F18		0xFFCF
#define IMXK_L8			0xFFCF
#define IMXK_F19		0xFFD0
#define IMXK_L9			0xFFD0
#define IMXK_F20		0xFFD1
#define IMXK_L10		0xFFD1
#define IMXK_F21		0xFFD2
#define IMXK_R1			0xFFD2
#define IMXK_F22		0xFFD3
#define IMXK_R2			0xFFD3
#define IMXK_F23		0xFFD4
#define IMXK_R3			0xFFD4
#define IMXK_F24		0xFFD5
#define IMXK_R4			0xFFD5
#define IMXK_F25		0xFFD6
#define IMXK_R5			0xFFD6
#define IMXK_F26		0xFFD7
#define IMXK_R6			0xFFD7
#define IMXK_F27		0xFFD8
#define IMXK_R7			0xFFD8
#define IMXK_F28		0xFFD9
#define IMXK_R8			0xFFD9
#define IMXK_F29		0xFFDA
#define IMXK_R9			0xFFDA
#define IMXK_F30		0xFFDB
#define IMXK_R10		0xFFDB
#define IMXK_F31		0xFFDC
#define IMXK_R11		0xFFDC
#define IMXK_F32		0xFFDD
#define IMXK_R12		0xFFDD
#define IMXK_F33		0xFFDE
#define IMXK_R13		0xFFDE
#define IMXK_F34		0xFFDF
#define IMXK_R14		0xFFDF
#define IMXK_F35		0xFFE0
#define IMXK_R15		0xFFE0

/* Modifiers */
#define IMXK_Shift_L		0xFFE1	/* Left shift */
#define IMXK_Shift_R		0xFFE2	/* Right shift */
#define IMXK_Control_L		0xFFE3	/* Left control */
#define IMXK_Control_R		0xFFE4	/* Right control */
#define IMXK_Caps_Lock		0xFFE5	/* Caps lock */
#define IMXK_Shift_Lock		0xFFE6	/* Shift lock */

#define IMXK_Meta_L		0xFFE7	/* Left meta */
#define IMXK_Meta_R		0xFFE8	/* Right meta */
#define IMXK_Alt_L		0xFFE9	/* Left alt */
#define IMXK_Alt_R		0xFFEA	/* Right alt */
#define IMXK_Super_L		0xFFEB	/* Left super */
#define IMXK_Super_R		0xFFEC	/* Right super */
#define IMXK_Hyper_L		0xFFED	/* Left hyper */
#define IMXK_Hyper_R		0xFFEE	/* Right hyper */

/*
**  Latin 1  Byte3 = 0
*/
#define IMXK_space               0x020
#define IMXK_exclam              0x021
#define IMXK_quotedbl            0x022
#define IMXK_numbersign          0x023
#define IMXK_dollar              0x024
#define IMXK_percent             0x025
#define IMXK_ampersand           0x026
#define IMXK_apostrophe          0x027
#define IMXK_quoteright          0x027	/* deprecated */
#define IMXK_parenleft           0x028
#define IMXK_parenright          0x029
#define IMXK_asterisk            0x02a
#define IMXK_plus                0x02b
#define IMXK_comma               0x02c
#define IMXK_minus               0x02d
#define IMXK_period              0x02e
#define IMXK_slash               0x02f
#define IMXK_0                   0x030
#define IMXK_1                   0x031
#define IMXK_2                   0x032
#define IMXK_3                   0x033
#define IMXK_4                   0x034
#define IMXK_5                   0x035
#define IMXK_6                   0x036
#define IMXK_7                   0x037
#define IMXK_8                   0x038
#define IMXK_9                   0x039
#define IMXK_colon               0x03a
#define IMXK_semicolon           0x03b
#define IMXK_less                0x03c
#define IMXK_equal               0x03d
#define IMXK_greater             0x03e
#define IMXK_question            0x03f
#define IMXK_at                  0x040
#define IMXK_A                   0x041
#define IMXK_B                   0x042
#define IMXK_C                   0x043
#define IMXK_D                   0x044
#define IMXK_E                   0x045
#define IMXK_F                   0x046
#define IMXK_G                   0x047
#define IMXK_H                   0x048
#define IMXK_I                   0x049
#define IMXK_J                   0x04a
#define IMXK_K                   0x04b
#define IMXK_L                   0x04c
#define IMXK_M                   0x04d
#define IMXK_N                   0x04e
#define IMXK_O                   0x04f
#define IMXK_P                   0x050
#define IMXK_Q                   0x051
#define IMXK_R                   0x052
#define IMXK_S                   0x053
#define IMXK_T                   0x054
#define IMXK_U                   0x055
#define IMXK_V                   0x056
#define IMXK_W                   0x057
#define IMXK_X                   0x058
#define IMXK_Y                   0x059
#define IMXK_Z                   0x05a
#define IMXK_bracketleft         0x05b
#define IMXK_backslash           0x05c
#define IMXK_bracketright        0x05d
#define IMXK_asciicircum         0x05e
#define IMXK_underscore          0x05f
#define IMXK_grave               0x060
#define IMXK_quoteleft           0x060	/* deprecated */
#define IMXK_a                   0x061
#define IMXK_b                   0x062
#define IMXK_c                   0x063
#define IMXK_d                   0x064
#define IMXK_e                   0x065
#define IMXK_f                   0x066
#define IMXK_g                   0x067
#define IMXK_h                   0x068
#define IMXK_i                   0x069
#define IMXK_j                   0x06a
#define IMXK_k                   0x06b
#define IMXK_l                   0x06c
#define IMXK_m                   0x06d
#define IMXK_n                   0x06e
#define IMXK_o                   0x06f
#define IMXK_p                   0x070
#define IMXK_q                   0x071
#define IMXK_r                   0x072
#define IMXK_s                   0x073
#define IMXK_t                   0x074
#define IMXK_u                   0x075
#define IMXK_v                   0x076
#define IMXK_w                   0x077
#define IMXK_x                   0x078
#define IMXK_y                   0x079
#define IMXK_z                   0x07a
#define IMXK_braceleft           0x07b
#define IMXK_bar                 0x07c
#define IMXK_braceright          0x07d
#define IMXK_asciitilde          0x07e


#endif   /* End of _IM_KEYMAP_H */






