/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/*
**  Define Basic Session Structure
*/

#ifndef _SES_ELEMENT_H
#define _SES_ELEMENT_H

#include "GeneType.h"
#include "CikuOper.h"

#ifdef	__cplusplus
extern	"C" {
#endif

#define  PYIM_RESTORE_ALL       0
#define  PYIM_RESTORE_LAST      1

#define  UHLF                 128
#define  UONE                 256
#define  UTWO                 512

#define  F_PREVPAGE           0x0001
#define  F_NEXTPAGE           0x0002
#define  F_PREVPAGE_BLINK     0x0004
#define  F_NEXTPAGE_BLINK     0x0008
#define  F_LEFTARROW          0x0010
#define  F_RIGHTARROW         0x0020
#define  F_LEFTARROW_BLINK    0x0040
#define  F_RIGHTARROW_BLINK   0x0080
#define  F_HALFWIDTH          0x0100
#define  F_FULLWIDTH          0x0200
#define  F_SETUP              0x0400
#define  F_SETUP_BLINK        0x0800

#define  SESPY_TYPE_QP        1       /* Quan Pin */
#define  SESPY_TYPE_SP        2       /* Shuang Pin */
#define  SESPY_TYPE_JP1       3       /* Japanese One */
#define  SESPY_TYPE_JP2       4       /* Japanese Two */
#define  SESPY_TYPE_GC        5       /* Greece */
#define  SESPY_TYPE_RS        6       /* Russian */

typedef struct _SesGuiElement {
	JINT      nPinyinType;
	JINT      nPrevKeyLayMode;
	JINT      nKeyLayMode;
	JINT      nPunctMode;
	JWORD     pwSpRawPyStr[40];        /* After each EditKey or SelectKey, this item was converted */
	                                   /* to pwRawPyStr[256], and then was Prased to pwPrsPyStr */
	JWORD     pwSpMixPeStr[256];       /* Mixed ShuangPinyin and HanziString, unParased!! */
	JINT      nSpRawCaretPos;          /* nSpRawCaretPos is relative to pwSpMixPeStr[256]!! Not pwSpRawPyStr */
	JWORD     pwSpSlctRawPy[512];      /* Crossponding Shuang Pinyin (include <'> <~>) of Item15, septed by 0009 */
	
	JWORD     pwRawPyStr[256];         /* Item1:  Raw PinYin Keystroke include <a...z> , <'>  <~> */
	JWORD     pwMixPeStr[256];         /* Item2:  Mix PinYin Hanzi string, unParased */
	JWORD     pwPrsPyStr[512];         /* Item3:  Parsed PinYin String (of Item2) include SPACE */
	JINT      nPrsPyYjCode[256];       /* Item4:  Integer Form of Item3 */
	JWORD     pwPrsMixStr[512];        /* Item5:  Parsed Form of Item2 */
	JINT      nRawCaretPos;            /* Item6:  Raw Caret Position relative to Item2 */
	
	JWORD     pwViewPe[128];           /* Item7:  Viewable content of Item5 */
	JINT      nViewCaretPos;           /* Item8:  Item6 relative to Item9 */
	JINT      nViewPeStart;            /* Item9:  Start of Item7 */
	JINT      nViewPeEnd;              /* Item10: End of Item7 */
	
	SysCandi  scSysCandi;              /* Item11: Defined in "CikuOper.h" */
	UdcCandi  ucUdcCandi;              /* Item12: Defined in "CikuOper.h" */
	JINT      nViewPage;               /* Item13: Current View Candi Page Number. The Min Value is 0 */
	JWORD     pwViewCandi[128];        /* Item14: Viewable Content of Item11 */
	JINT      nViewCandiStart;         /* Item15: Start of Item12 */
	JINT      nViewCandiEnd;           /* Item16: End of Item12 + 1, !!!! If there are 12 single Hanzi candi.,
	                                   **         For first View Candi page, nViewCandiStart is 0, 
	                                   **         nViewCandiEnd is 7.
	                                   */
	
	JWORD     pwSlctHz[512];           /* Item17: Selected Hanzi of Every Step, each seperated by 0009 */
	JWORD     pwSlctRawPy[512];        /* Item18: Crossponding Pinyin (include <'> <~>) of Item15, septed by 0009 */
	JINT      nSlctSteps;              /* Item19: Step Number of Selection */
	
	JWORD     pwCommit[256];           /* Item20: Committed String. After each commit, must init this struct to New it */
	JINT      nErrorCode;              /* Item21: ErrorCode. Before processing each new KeySym, must set ErrorCode to ZERO */
	JWORD     pwStatus[16];            /* Item22: IM name field. For Example, "QuanPin", "ShuangPin" */
	JINT      nIconFlag;               /* Item23: Bitwise Flag for Icons */
	
	/* The following 3 items were added to Fix Bug 4165549: Scott Ma, 12/8, 1998 */
	JINT      nPrevMatchMode;
	JINT      pnCurChoiceYjNew[9];
	JINT      pnCurChoiceYjOld[9];
} SesGuiElement;

#ifdef	__cplusplus
}
#endif

#endif  /* End of _SES_ELEMENT_H */

