/*
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

#ifndef SUNIMCORE_H
#define SUNIMCORE_H

typedef struct _iml_inst_mem_block_list	iml_inst_mem_block_list_t;
typedef struct _iml_inst_mem_elem_list	iml_inst_mem_elem_list_t;

typedef struct _iml_session {
  /* public */
    iml_if_t *If;			/* parent IF */
    iml_desktop_t *desktop;		/* parent desktop */
    void *specific_data;		/* specific data per session */
    int current_active_region;		/* check active region */
    int public_status;			/* check conversion on/off */

  /* private */
    IMPreeditDrawCallbackStruct PreEditTextInfo; /* preedit cache */
    int PreEditTextBufferSize;
    int PreEditAttrBufferSize;

    status_cache_t status_cache;		/* cache for status string */

    iml_inst_mem_block_list_t *mem_block_short_term_small;
    iml_inst_mem_elem_list_t *mem_elem_short_term;
    iml_inst_mem_elem_list_t *mem_elem_long_term;

    void *SessionContext;			/* reference for iml_execute() */

    struct _iml_session *next;			/* link */
}   iml_session_t;

#endif
