#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include <iiimp-data.h>

#include "iiimp-dataP.h"

#define IMEINFO_OBJECT_SIZE 4 * 9

IIIMP_imeinfo *
iiimp_imeinfo_new(
    IIIMP_data_s *	data_s,
    IIIMP_card32	enable,
    IIIMP_string *	ime_id,
    IIIMP_string *	imename,
    IIIMP_string *	version,
    IIIMP_string *	description,
    IIIMP_string *	author,
    IIIMP_string *	copyright,
    IIIMP_string *	reserved1,
    IIIMP_string *	reserved2)
{
    IIIMP_imeinfo *	imeinfo;

    imeinfo = (IIIMP_imeinfo *)malloc(sizeof (IIIMP_imeinfo));
    if (NULL == imeinfo) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    imeinfo->nbyte = 4; /* for enable */
    imeinfo->next = NULL;

    if (NULL == ime_id) {
	imeinfo->nbyte += 4;
    } else {
	imeinfo->nbyte += ime_id->nbyte;
    }
    if (NULL == imename) {
	imeinfo->nbyte += 4;
    } else {
	imeinfo->nbyte += imename->nbyte;
    }
    if (NULL == version) {
	imeinfo->nbyte += 4;
    } else {
	imeinfo->nbyte += version->nbyte;
    }
    if (NULL == description) {
	imeinfo->nbyte += 4;
    } else {
	imeinfo->nbyte += description->nbyte;
    }
    if (NULL == author) {
        imeinfo->nbyte += 4;
    } else {
        imeinfo->nbyte += author->nbyte;
    }
    if (NULL == copyright) {
        imeinfo->nbyte += 4;
    } else {
        imeinfo->nbyte += copyright->nbyte;
    }
    if (NULL == reserved1) {
        imeinfo->nbyte += 4;
    } else {
        imeinfo->nbyte += reserved1->nbyte;
    }
    if (NULL == reserved2) {
        imeinfo->nbyte += 4;
    } else {
        imeinfo->nbyte += reserved2->nbyte;
    }

    imeinfo->enable = enable;
    imeinfo->ime_id = ime_id;
    imeinfo->imename = imename;
    imeinfo->version = version;
    imeinfo->description = description;
    imeinfo->author = author;
    imeinfo->copyright = copyright;
    imeinfo->reserved1 = reserved1;
    imeinfo->reserved2 = reserved2;

    return imeinfo;
}

void
iiimp_imeinfo_delete(IIIMP_data_s * data_s, IIIMP_imeinfo * imeinfo)
{
    if (NULL == imeinfo) return;
    iiimp_string_delete(data_s, imeinfo->ime_id);
    iiimp_string_delete(data_s, imeinfo->imename);
    iiimp_string_delete(data_s, imeinfo->version);
    iiimp_string_delete(data_s, imeinfo->description);
    iiimp_string_delete(data_s, imeinfo->author);
    iiimp_string_delete(data_s, imeinfo->copyright);
    iiimp_string_delete(data_s, imeinfo->reserved1);
    iiimp_string_delete(data_s, imeinfo->reserved2);
    free(imeinfo);
    return;
}

void
iiimp_imeinfo_list_delete(IIIMP_data_s * data_s, IIIMP_imeinfo * imeinfo)
{
    IIIMP_imeinfo *	imeinfo_next;
    for (; NULL != imeinfo; imeinfo = imeinfo_next) {
	imeinfo_next = imeinfo->next;
	iiimp_imeinfo_delete(data_s, imeinfo);
    }
    return;
}

void
iiimp_imeinfo_pack(
    IIIMP_data_s *	data_s,
    IIIMP_imeinfo *	m,
    size_t *		nbyte,
    uchar_t **		ptr)
{
    size_t	rest;
    uchar_t *	p;

    rest = *nbyte;
    p = *ptr;

    PUT32(m->enable, rest, p, data_s->byte_swap);
    iiimp_string_pack(data_s, m->ime_id, &rest, &p);
    iiimp_string_pack(data_s, m->imename, &rest, &p);
    iiimp_string_pack(data_s, m->version, &rest, &p);
    iiimp_string_pack(data_s, m->description, &rest, &p);
    iiimp_string_pack(data_s, m->author, &rest, &p);
    iiimp_string_pack(data_s, m->copyright, &rest, &p);
    iiimp_string_pack(data_s, m->reserved1, &rest, &p);
    iiimp_string_pack(data_s, m->reserved2, &rest, &p);

    *nbyte -= rest;
    *ptr = p;

    return;
}


void
iiimp_imeinfo_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_imeinfo *	m,
    size_t *		nbyte,
    uchar_t **		ptr)
{
    size_t	rest;
    uchar_t *	p;

    rest = *nbyte;
    p = *ptr;

    for (; NULL != m; m = m->next) {
	iiimp_imeinfo_pack(data_s, m, &rest, &p);
    }

    *nbyte -= rest;
    *ptr = p;

    return;
}


IIIMP_imeinfo *
iiimp_imeinfo_unpack(
    IIIMP_data_s *      data_s,
    size_t *            nbyte,
    const uchar_t **    ptr,
    size_t              nbyte_max)
{
    IIIMP_imeinfo *    imeinfo;
    size_t              rest;
    const uchar_t *     p;

    if (nbyte_max == 0) return NULL;

    rest = nbyte_max;
    p = *ptr;

    if ((*nbyte < rest) || (rest < IMEINFO_OBJECT_SIZE)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    imeinfo = (IIIMP_imeinfo *)malloc(sizeof (IIIMP_imeinfo));
    if (NULL == imeinfo) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    memset (imeinfo, 0, sizeof (IIIMP_imeinfo));

    /*
     * the imeinfo is optional, so we don't need to check the following members 
     * are NULL or not.
     */
    GET32(imeinfo->enable, rest, p, data_s->byte_swap);
    imeinfo->ime_id = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->imename = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->version = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->description = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->author = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->copyright = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->reserved1 = iiimp_string_unpack(data_s, &rest, &p, rest);
    imeinfo->reserved2 = iiimp_string_unpack(data_s, &rest, &p, rest);

    *nbyte -= (nbyte_max - rest);
    *ptr = p;

    return imeinfo;
}


IIIMP_imeinfo *
iiimp_imeinfo_list_unpack(
    IIIMP_data_s *      data_s,
    size_t *            nbyte,
    const uchar_t **    ptr,
    size_t              nbyte_max)
{
    IIIMP_imeinfo *    imeinfo;
    size_t              rest;
    const uchar_t *     p;
    IIIMP_imeinfo *    imeinfo_first;
    IIIMP_imeinfo *    imeinfo_last;

    if (nbyte_max == 0) return NULL;

    rest = nbyte_max;
    p = *ptr;
    imeinfo = NULL;
    imeinfo_first = NULL;
    imeinfo_last = NULL;

    if ((*nbyte < rest) || (rest < IMEINFO_OBJECT_SIZE)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    while (0 < rest) {
	imeinfo = iiimp_imeinfo_unpack(data_s, &rest, &p, rest);
	if (NULL == imeinfo) {
          /* imeinfo is optional, so it is ok if imeinfo is NULL */
          break;
	} else {
	    if (NULL == imeinfo_first) {
		imeinfo_first = imeinfo;
	    } else {
		imeinfo_last->next = imeinfo;
	    }
	    imeinfo_last = imeinfo;
	}
    }

    *nbyte -= (nbyte_max - rest);
    *ptr = p;

    return imeinfo_first;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
