// -*- C++ -*-
// --------------------------------------------------------------------
// IpeCanvasPainter
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2007  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPECANVASPAINTER_H
#define IPECANVASPAINTER_H

#include "ipegeo.h"
#include "ipecolor.h"
#include "ipepainter.h"

// --------------------------------------------------------------------

class IpeStyleSheet;

class IpePdfObj;

class QWidget;
class QPainter;

// --------------------------------------------------------------------

class IpeCanvasPainter : public IpePainter {
public:
  IpeCanvasPainter(const IpeStyleSheet *sheet,
		   IpeCanvasFonts *fonts,
		   QPainter *painter,
		   double zoom, bool pretty,
		   int maxBitmapSize);
  virtual ~IpeCanvasPainter() { }

  void SetDimmed(bool dim) { iDimmed = dim; }

protected:
  virtual void DoMoveTo(const IpeVector &v);
  virtual void DoLineTo(const IpeVector &v);
  virtual void DoCurveTo(const IpeVector &v1, const IpeVector &v2,
			 const IpeVector &v3);
  virtual void DoClosePath();

  virtual void DoDrawPath();
  virtual void DoDrawBitmap(IpeBitmap bitmap);
  virtual void DoDrawText(const IpeText *text);

private:
  void DimColor(QColor &col);
  bool DrawChar(int ch, QRgb rgb, int x, int y);
  void Execute(const IpeBuffer &buffer);
  void ClearArgs();
  void Opcm();
  void OpBT();
  void OpTf();
  void OpTd();
  void OpTJ();
  void Opk(bool stroke);
  void Opg(bool stroke);
  void Oprg(bool stroke);
  void Opw();
  void Opm();
  void Opl();

private:
  IpeCanvasFonts *iFonts;
  QPainter *iPainter;
  double iZoom;
  bool iPretty;
  int iMaxBitmapSize;

  bool iDimmed;

  enum TVertexType { EMoveTo, ELineTo, ECurveTo,
		     EEndPath, EEndClosedPath };

  std::vector<QPointF> iV;
  std::vector<TVertexType> iType;

  IpeAttribute iDash[4]; // dash, dot, dash dot, dash dot dot

  // PDF operator drawing
  std::vector<const IpePdfObj *> iArgs;
  uint iTextRgb;
  uint iStrokeRgb;
  uint iFillRgb;
  double iLineWid;
  IpeVector iMoveTo;
  // text state
  IpeFaceSize *iFont;  // not owned
  double iFontSize;
  IpeVector iTextPos;
};

// --------------------------------------------------------------------
#endif
