/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ipodmountpoint.h"

#include <qfile.h>
#include <qtextstream.h>

IPodMountPoint::IPodMountPoint(const QString& entry) {
    fields = QStringList::split(" ", entry);
}


IPodMountPoint::~IPodMountPoint()
{
}


const QString& IPodMountPoint::getField(uint fieldnum) const {
    if (fields.size() < fieldnum + 1)
        return QString::null;
    else
        return fields[fieldnum];
}

const QString& IPodMountPoint::getDevice() const {
    return getField(0);
}

const QString& IPodMountPoint::getMountPoint() const {
    return getField(1);
}

const QString& IPodMountPoint::getFsType() const {
    return getField(2);
}

const QString& IPodMountPoint::getOptions() const {
    return getField(3);
}

bool IPodMountPoint::possiblyAnIpod() const {
    QString device = getDevice();
    
    if ((device.find("/dev/sd") == 0 || device.find("scsi") >= 0 || // some kinda scsi device
        device.find("ipod") >= 0 || // special device for ipod
        device.endsWith("2") || // is the 2nd (windows ipod) ...
        device.endsWith("3")) &&    // ... or the 3rd (apple) partition
        QFile::exists(getMountPoint() + "/iPod_Control")) {
        return true;
    } else {
        return false;
    }
}


IPodMountPoint::List IPodMountPoint::mountedIPods() {
    List list;
    
    QFile procMounts("/proc/mounts");
    // QFile procMounts("/etc/mtab");
    procMounts.open(IO_ReadOnly);
    QTextStream instream(&procMounts);
    
    while (!instream.atEnd()) {
        QString line = instream.readLine();
        if (!line.isEmpty()) {
            IPodMountPoint mountpoint(line);
            // only care about "possibly an ipod" devices (filter out network shares and floppies)
            if (mountpoint.possiblyAnIpod())
                list.append(mountpoint);
        }
    }
    
    instream.unsetDevice();
    procMounts.close();
    
    return list;
}

