#include "libcompat.h"
#include "autocurses.h"

#if HAVE_VWPRINTW

int vw_printw(WINDOW *win, const char *fmt, va_list varglist)
{
    return vwprintw(win, fmt, varglist);
}

#else

#  include <stdio.h>

#  warning Using a limited implementation of vw_printw with a fixed maximum size

int vw_printw(WINDOW *win, const char *fmt, va_list varglist)
{
    char buf[1024];
    int rval = vsnprintf(buf, sizeof buf, fmt, varglist);

    waddstr(win, buf);
    return rval;
}

#endif
