dnl CHECK_*CURSES([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_NCURSES],dnl
[AC_SEARCH_LIBS([_nc_flush], [ncurses curses], [$1], [$2])])dnl
AC_DEFUN([CHECK_XCURSES],dnl
[AC_CHECK_LIB(XCurses, [Xinitscr],dnl
	LIBS="$LIBS $(xcurses-config --libs)" [$1],dnl
	[$2], $(xcurses-config --libs 2>/dev/null))])dnl
AC_DEFUN([CHECK_PDCURSES],dnl
[AC_SEARCH_LIBS([PDC_sync], [pdcurses curses], [$1], [$2])])dnl
AC_DEFUN([CHECK_SLCURSES],dnl
[AC_SEARCH_LIBS([SLcurses_initscr], [slang curses], [$1], [$2])])dnl
AC_DEFUN([CHECK__CURSES],dnl
[AC_SEARCH_LIBS([initscr], [curses ncurses pdcurses XCurses], [$1], [$2])])dnl


dnl CHECK_CURSES
AC_DEFUN([CHECK_CURSES],dnl
[AC_ARG_WITH([curses], AS_HELP_STRING([--with-curses],dnl
	[choose which curses library to use (default = auto)]), ,dnl
	[with_curses=auto])
case "$with_curses" in
"ncurses")
	CHECK_NCURSES([], AC_MSG_ERROR([ncurses was not found])) ;;
"xcurses")
	CHECK_XCURSES([], AC_MSG_ERROR([xcurses was not found])) ;;
"pdcurses")
	CHECK_PDCURSES([], AC_MSG_ERROR([pdcurses was not found])) ;;
"slang")
	CHECK_SLCURSES([], AC_MSG_ERROR([S-Lang curses was not found])) ;;
"curses")
	CHECK__CURSES([], AC_MSG_ERROR([curses was not found])) ;;
"auto")
	CHECK_NCURSES([with_curses=ncurses],
	CHECK_XCURSES([with_curses=xcurses],
	CHECK_PDCURSES([with_curses=pdcurses],
	CHECK__CURSES([with_curses=curses],
		AC_MSG_ERROR([no curses library found]))))) ;;
*)
	AC_MSG_ERROR([Unknown option --with-curses='$with_curses']) ;;
esac
case "$with_curses" in
"ncurses")	AC_DEFINE(USE_NCURSES, 1, [Define to 1 to use ncurses]) ;;
"xcurses")	AC_DEFINE(USE_XCURSES, 1, [Define to 1 to use XCurses]) ;;
"pdcurses")	AC_DEFINE(USE_PDCURSES, 1, [Define to 1 to use pdcurses]) ;;
"slang")	AC_DEFINE(USE_SLANG, 1, [Define to 1 to use S-Lang curses]) ;;
"curses")	AC_DEFINE(USE_CURSES, 1, [Define to 1 to use curses]) ;;
*)		AC_MSG_ERROR([Unknown curses library '$with_curses']) ;;
esac[]dnl
])dnl


dnl CHECK_CURSES_FUNC(RETTYPE, FUNCTION, ARGS, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([CHECK_CURSES_FUNC],dnl
[AX_CHECK_FUNC_ARGS(["$srcdir/src/autocurses.h"], [$1], [$2], [$3],dnl
		AC_DEFINE(AS_TR_CPP(HAVE_$2), [1],dnl
		[Define to 1 if you have the ']$2[' function.]) [$4], [$5])dnl
])dnl

dnl REPLACE_CURSES_FUNC(RETTYPE, FUNCTION, ARGS, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([REPLACE_CURSES_FUNC],dnl
[CHECK_CURSES_FUNC([$1], [$2], [$3], [$4], [AC_LIBOBJ([$2])] [$5])])dnl
