/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_alarm.c,v $ -- alarm support via SIGUSR?
 * $Id: mod_alarm.c,v 1.7 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by David E. Potter
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <dirent.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include "config.h"
#include "irmp3config.h"
#include "irmp3tools.h"
#include "irmp3log.h"
#include "irmp3mod.h"
#include "mod_alarm.h"


/*************************************************************************
 * GLOBALS
 */

int alarm_allow = 1;


/*************************************************************************
 * MODULE INFO
 */
mod_t mod_alarm = {
	"mod_alarm",
	mod_alarm_deinit,	// deinit
	NULL,			// reload
	&blank_fd,		// watchfd
	NULL,			// poll
	NULL,			// update
	mod_alarm_message,	// message
	NULL,			// SIGCHLD handler
	mod_alarm_init,
	NULL,			// avoid warning
};


/*************************************************************************
 * MODULE INIT FUNCTION
 */
char *mod_alarm_init (void)
{
	log_printf(LOG_DEBUG, "mod_alarm_init(): initializing\n");

	// catch SIGUSR1 signals
	signal(SIGUSR1,mod_alarm1_signal);
	signal(SIGUSR2,mod_alarm2_signal);

	return NULL;
}

void mod_alarm1_signal()
{
	log_printf(LOG_DEBUG, "mod_alarm1_signal(): caught a SIGUSR1 signal.\n");
	if(alarm_allow) {
		log_printf(LOG_DEBUG, "mod_alarm1_signal(): Sounding alarm...\n");
		mod_sendmsg(MSGTYPE_INPUT, "environment alarm1");
	} else log_printf(LOG_DEBUG, "mod_alarm1_signal(): skipping alarm since alarms are disabled.\n");
	
}

void mod_alarm2_signal()
{
	log_printf(LOG_DEBUG, "mod_alarm2_signal(): caught a SIGUSR2 signal. Sounding alarm....\n");
	if(alarm_allow) {
		log_printf(LOG_DEBUG, "mod_alarm1_signal(): Sounding alarm...\n");
		mod_sendmsg(MSGTYPE_INPUT, "environment alarm2");
	} else log_printf(LOG_DEBUG, "mod_alarm1_signal(): skipping alarm since alarms are disabled.\n");
	
}


/*************************************************************************
 * RECEIVE MESSAGE
 */
void mod_alarm_message (int msgtype, char *msg,const char __attribute__((unused))*sender)
{
	char *c1,*c2;

	// handle input messages
	if (msgtype == MSGTYPE_INPUT) {
		c1 =  strtok(msg, " \t");
		if(!c1) return;
		c2 = strtok(NULL, "");
		if(!c2) return;
		// process alarm commands
		if ( (!strcasecmp(c1, "alarm") || !strcasecmp(c1,"alarms"))) {
			if (!strcasecmp(c2,"1") || !strcasecmp(c2,"enable")) {
				log_printf(LOG_NORMAL,"Alarms enabled.\n");
				mod_sendmsg(MSGTYPE_EVENT, "alarm 1");
				alarm_allow = 1;
			} else if (!strcasecmp(c2,"0") || !strcasecmp(c2,"disable")) {
				log_printf(LOG_NORMAL,"Alarms disabled.\n");
				mod_sendmsg(MSGTYPE_EVENT, "alarm 0");
				alarm_allow = 0;
			} else log_printf(LOG_NORMAL,"mod_alarm(): unknown alarm command: %s %s.\n",c1,c2);
		}
	} 
}


/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_alarm_deinit (void)
{
	// do not catch SIGUSR1 signals
	log_printf(LOG_DEBUG, "mod_alarm_deinit(): not catching SIGUSR1 anymore.\n");
	signal(SIGUSR1,SIG_DFL);
	log_printf(LOG_DEBUG, "mod_alarm_deinit(): not catching SIGUSR2 anymore.\n");
	signal(SIGUSR2,SIG_DFL);

	log_printf(LOG_DEBUG, "mod_alarm_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */
