/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_idle.c,v $ -- monitor periods of idle time
 * $Id: mod_idle.c,v 1.10 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by David E. Potter
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <malloc.h>

#include "config.h"
#include "irmp3config.h"
#include "irmp3tools.h"
#include "irmp3log.h"
#include "irmp3mod.h"
#include "mod_idle.h"


/*************************************************************************
 * GLOBALS AND STATICS
 */

static unsigned int  idle_chunkiness;		// how often to announce idle state
static unsigned long idle_time = 0;		// total amount of time idle


/*************************************************************************
 * MODULE INFO
 */
mod_t mod_idle = {
	"mod_idle",
	mod_idle_deinit,	// deinit
	NULL,			// reload
	&blank_fd,		// watch_fdset
	NULL,			// poll
	NULL,			// update
	mod_idle_message, 	// message
	NULL,			// SIGCHLD handler
	mod_idle_init,
	NULL,			// avoid warning
};

void mod_idle_message (int msgtype, char *msg,const char __attribute__((unused))*sender)
{
	// it doesn't matter what the message is as long as it's not an IDLE msg.
	if(msgtype == MSGTYPE_EVENT) {
		if(!strncasecmp(msg,"play",4) || !strcasecmp(msg,"unpause")) {
			idle_time = 0;
			alarm(0);
		} else if (!strcasecmp(msg,"pause") || !strcasecmp(msg,"stop") || !strcasecmp(msg,"halt")) {
			alarm(idle_chunkiness);
			idle_time = 0;
		}
	}
}


/*************************************************************************
 * MODULE INIT FUNCTION
 */
char *mod_idle_init (void)
{

	idle_chunkiness = config_getnum("idle_interval",60);
	if (!idle_chunkiness) {
		log_printf(LOG_ERROR, "mod_idle_init(): Cannot find idle_time.\n");
	} else {
		signal(SIGALRM,mod_idle_alarm);
		log_printf(LOG_DEBUG, "mod_idle_init(): idle message granularity is %d second(s).\n",idle_chunkiness);
		alarm(idle_chunkiness);
	}
	return NULL;
}

/*************************************************************************
 * ALARM SIGNAL HANDLER
 */

void mod_idle_alarm(int __attribute__((unused)) signo)
{
	log_printf(LOG_NOISYDEBUG, "mod_idle_alarm(): Idle time reached\n");
	idle_time+=idle_chunkiness;
	alarm(idle_chunkiness);
	mod_sendmsgf(MSGTYPE_EVENT,"idle %d",idle_time);
}

/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_idle_deinit (void)
{
	log_printf(LOG_DEBUG, "mod_idle_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */
