(in-package :crypto-tests)


;;; standard tests

(digest-test "" "31d6cfe0d16ae931b73c59d7e0c089c0")
(digest-test "a" "bde52cb31de33e46245e05fbdbd6fb24")
(digest-test "abc" "a448017aaf21d8525fc10ae87aa6729d")
(digest-test "message digest" "d9130a8164549fe818874806e1c7014b")
(digest-test "abcdefghijklmnopqrstuvwxyz" "d79e1c308aa5bbcdeea8ed63df412da9")
(digest-test "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" "043f8582f241db351ce627e153e7f0e4")
(digest-test "12345678901234567890123456789012345678901234567890123456789012345678901234567890" "e33b4ddc9c38f2199c3e7b164fcc0536")


;;; bit-level tests from NESSIE (http://www.cryptonessie.org/)

(digest-bit-test 0 #x80 63 "BBD35E5215A4F49086AC51702AC8F453")
(digest-bit-test 0 #x40 63 "7F0784ACCCF41ED1BEFC001417DC177F")
(digest-bit-test 0 #x20 63 "8B32C668EA420DDD2D0D292F80209203")
(digest-bit-test 0 #x10 63 "1FDB0B6005B3FEBB4CCABAB9016E659F")
(digest-bit-test 0 #x08 63 "88BD1D0ABB04C65F942F381C1D10B4E8")
(digest-bit-test 0 #x04 63 "6D11C1CE327B4AF3219B8E7127F77F87")
(digest-bit-test 0 #x02 63 "ABD2C0F985A49416DD93353269CB8B6E")
(digest-bit-test 0 #x01 63 "D5ECE790332E2980B265A6C4ADA4B313")
(digest-bit-test 1 #x80 62 "1FE57101A89843C127B807A415E27174")
(digest-bit-test 1 #x40 62 "7A1DB4C6C50BA59D451FB3E8842B2E24")
(digest-bit-test 1 #x20 62 "C9241D9976E8794792CF7C752EA912A4")
(digest-bit-test 1 #x10 62 "BCDCA2DD3C1CC599328FDD433F65E5D6")
(digest-bit-test 1 #x08 62 "633ED249ECDDD2162778A3FB9C2101A9")
(digest-bit-test 1 #x04 62 "7B461DF7AFB13186981A8683102C440B")
(digest-bit-test 1 #x02 62 "F00EC0E84F45D2E8F1C3D098963BB556")
(digest-bit-test 1 #x01 62 "FBB41C20E1F771F8CF941DE587D46483")
(digest-bit-test 2 #x80 61 "CAE77290924AD0AF75C2040742D9A1DC")
(digest-bit-test 2 #x40 61 "CA066A24C77C269F054C1C5878E4E80C")
(digest-bit-test 2 #x20 61 "A1640FC6F5D39B124622C479995AF67D")
(digest-bit-test 2 #x10 61 "B88105189B7FB16E6014DC734AF561D6")
(digest-bit-test 2 #x08 61 "2285357FAE38EE229777CF2785B97281")
(digest-bit-test 2 #x04 61 "107E5822CB98AFB516A5B447C7727978")
(digest-bit-test 2 #x02 61 "4B710DF5F98A1497BE0807692F8FB1DB")
(digest-bit-test 2 #x01 61 "F26FBF349B2373A944684CE0EE801E20")
(digest-bit-test 3 #x80 60 "F7A42E8770042DF7710E016FC46658C0")
(digest-bit-test 3 #x40 60 "293ACF948761A14FC464EF1500DE9C3F")
(digest-bit-test 3 #x20 60 "BC7893BB2CF21E9EC9334AC6765EBF2B")
(digest-bit-test 3 #x10 60 "45B42B939CF8F1FBB57C5C98837E8B38")
(digest-bit-test 3 #x08 60 "4D0F25D2E48D8720D1E6E132DC6B07BF")
(digest-bit-test 3 #x04 60 "F6547862D7627CB5B0AB492DEBF82084")
(digest-bit-test 3 #x02 60 "671FC792B2855699762FE44EDFBB1F49")
(digest-bit-test 3 #x01 60 "CA1A6A7C4C83C3F2B784A266DED6B5DE")
(digest-bit-test 4 #x80 59 "07081DEA52B67A10352400DD2E493B5E")
(digest-bit-test 4 #x40 59 "8EEA6F82A654706114819BA76492B02C")
(digest-bit-test 4 #x20 59 "77F832636B2A4F548F9561B50F00D04F")
(digest-bit-test 4 #x10 59 "D85CC14ABB85E1AF9BB0031FD1A0F4E5")
(digest-bit-test 4 #x08 59 "8477AD6B25C8329A8E9961E918E509A9")
(digest-bit-test 4 #x04 59 "3772EFC29E9B49E745B244C0533208BF")
(digest-bit-test 4 #x02 59 "9672F5178E99A1F2D0EE8AAD91773C83")
(digest-bit-test 4 #x01 59 "CD286A0381B2B92CC8B5D97B3724B44A")
(digest-bit-test 5 #x80 58 "22F9C5DAC3B12BFEDEBE79D5A92CD71E")
(digest-bit-test 5 #x40 58 "0CE9433431E2C994C3B3E8C313AF7E53")
(digest-bit-test 5 #x20 58 "BF26B54EDCD513D58812A4B098D782C5")
(digest-bit-test 5 #x10 58 "63390175CB490D30165690B47F984DBC")
(digest-bit-test 5 #x08 58 "93B57559DDD377AF5C8FA4A588B7E403")
(digest-bit-test 5 #x04 58 "537DC75DD559E080AACA55921A3CB5E6")
(digest-bit-test 5 #x02 58 "6AEBF1038DF6894C14EFD3F8B868D391")
(digest-bit-test 5 #x01 58 "07EF953031EC4EFDD007A7445B13016D")
(digest-bit-test 6 #x80 57 "D19B3DA81B887021117AACE297455878")
(digest-bit-test 6 #x40 57 "889031546AE1F9195E824D5257E9BF99")
(digest-bit-test 6 #x20 57 "8944E2D679925948C153821926508797")
(digest-bit-test 6 #x10 57 "979E317C4EEB567F419289872669B7B6")
(digest-bit-test 6 #x08 57 "17781CF3EF732E6848B76239B89B8765")
(digest-bit-test 6 #x04 57 "12AC5D1727F09C1E8EF91352EDCB499F")
(digest-bit-test 6 #x02 57 "7873D8BCC863F163F535468F804ABF12")
(digest-bit-test 6 #x01 57 "3A1AEF9C29E5208BB6153148EC45DA3B")
(digest-bit-test 7 #x80 56 "1DCF200C9E0595290506EE6DE6C80347")
(digest-bit-test 7 #x40 56 "244B3E0B1EF717E2684947609FCF0F5C")
(digest-bit-test 7 #x20 56 "B6ED2988D01B395A48A554BBDCD2235A")
(digest-bit-test 7 #x10 56 "4E5066C4CF9445BF14C96B9ADB0CBBC0")
(digest-bit-test 7 #x08 56 "D734B03840FA5D4815047D384AE8F957")
(digest-bit-test 7 #x04 56 "0C3E357ED652686CA8ACC945A8A9399B")
(digest-bit-test 7 #x02 56 "4A96F69D1F332D13C53B75EC0EC9A98C")
(digest-bit-test 7 #x01 56 "C7E506B3C26B016FB58B93C6DC24455C")
(digest-bit-test 8 #x80 55 "5341A52A09F29AA025C586C6F30871CD")
(digest-bit-test 8 #x40 55 "BCA78320EA99A7EF42F5C50470FB170D")
(digest-bit-test 8 #x20 55 "6322D5E6AF7AB230A6B95029C052E15D")
(digest-bit-test 8 #x10 55 "1F71B30932FBCC899A96179587162C21")
(digest-bit-test 8 #x08 55 "DF6BC482AF780F888EF4816889AD3F72")
(digest-bit-test 8 #x04 55 "90EF7853DAA5A1FE63DEBAD8EE1244C6")
(digest-bit-test 8 #x02 55 "B25B09E34F72C81E03BA18A82861A281")
(digest-bit-test 8 #x01 55 "67F251CB476F65AD4FA54271BCC2D5DC")
(digest-bit-test 9 #x80 54 "F38437C6EA09FEB3D408685F6ACB14E5")
(digest-bit-test 9 #x40 54 "ACEC89994059ACA9F7969E349F43A078")
(digest-bit-test 9 #x20 54 "22B584E43A310FE4A95D008AF6F53578")
(digest-bit-test 9 #x10 54 "555694DBA0468B7E47699C195F14BAD4")
(digest-bit-test 9 #x08 54 "00A3F64332DCF7F56C573EC1F69B7941")
(digest-bit-test 9 #x04 54 "BA0C7968D94657547F7BAC324D75ECFE")
(digest-bit-test 9 #x02 54 "D670D44E05180676F3F130B22A210701")
(digest-bit-test 9 #x01 54 "F7A6A4776F5AEE80DD9E799628312E67")
(digest-bit-test 10 #x80 53 "5C244D2D5B727BB5755F727366453FA9")
(digest-bit-test 10 #x40 53 "1E3557F5CCA3A449BAC3C975BBB929CA")
(digest-bit-test 10 #x20 53 "29E48D6E694AA6B88816DF35AD0EBA20")
(digest-bit-test 10 #x10 53 "611AE1550A2163E622EA480E70B0B76A")
(digest-bit-test 10 #x08 53 "FB2BDC98CF0C8ACBDB83DB241E8EB776")
(digest-bit-test 10 #x04 53 "B58BCD699DEE5DAA2D7571AF100B8068")
(digest-bit-test 10 #x02 53 "EB019E3CFB9C824227F958688A39A8BD")
(digest-bit-test 10 #x01 53 "2C6AF1FDAE0FCBB979FBD296F869397D")
(digest-bit-test 11 #x80 52 "1240B2BD883CC2E6B79851E440BEE571")
(digest-bit-test 11 #x40 52 "7F4A696A12E446D750361491459C3366")
(digest-bit-test 11 #x20 52 "63DD0E996BD33ED0AC66B10363878EA2")
(digest-bit-test 11 #x10 52 "D6E9605298D44D3C1544F27E5F25DB99")
(digest-bit-test 11 #x08 52 "476C4D1C167B5178A5B1FD7E32433DBC")
(digest-bit-test 11 #x04 52 "EBB2643274CBB654258610B16F9A86D8")
(digest-bit-test 11 #x02 52 "17CCF469B50EA792EF05FC3BBFDCF71D")
(digest-bit-test 11 #x01 52 "C1F9C8646DB996F208D14A7F68AA8169")
(digest-bit-test 12 #x80 51 "32BB562417D57CCE8232D64247B9F59D")
(digest-bit-test 12 #x40 51 "8AE16E4ACC1DDBA9A94A584EA0D2E3F9")
(digest-bit-test 12 #x20 51 "07D272C782E6CAB67EFE5B1A9E6AFF9E")
(digest-bit-test 12 #x10 51 "095225F76964298D4526399E2B256AE3")
(digest-bit-test 12 #x08 51 "5FD4EC9766AAB9298DF74B3BB309B2F8")
(digest-bit-test 12 #x04 51 "AE1CBA144FDC928C587DFDB66EE195F8")
(digest-bit-test 12 #x02 51 "0BBC13567EC582FFBFBD284EC559935D")
(digest-bit-test 12 #x01 51 "E4EEA7ED1354FF9C991128EA6EF05A37")
(digest-bit-test 13 #x80 50 "92256984D50F23C70211F228C33125C6")
(digest-bit-test 13 #x40 50 "F7CB16B72B1917924C3D27078ED46D14")
(digest-bit-test 13 #x20 50 "82061087C8424761ECCB8A33427EFD71")
(digest-bit-test 13 #x10 50 "513B968E2DC615D856D8A487459C08DC")
(digest-bit-test 13 #x08 50 "78C86BCCA923AF0107DC20D04143356F")
(digest-bit-test 13 #x04 50 "B62193B828B5A1B5E79C85230074A503")
(digest-bit-test 13 #x02 50 "6D3607862B7A14C74B2C3FC264FF938F")
(digest-bit-test 13 #x01 50 "6C268B65574C7E71B1B33A9FBA073028")
(digest-bit-test 14 #x80 49 "6EAF3875811D115C423CBDB782CEDB53")
(digest-bit-test 14 #x40 49 "76733B1C620219C48B3949EB79BB6162")
(digest-bit-test 14 #x20 49 "07C291BFECC39263CE9BEBB61D4F0151")
(digest-bit-test 14 #x10 49 "3561F4C91950702DA3C446A3FC608D47")
(digest-bit-test 14 #x08 49 "DFAAD6F42AD6D1EA80D18482825D7642")
(digest-bit-test 14 #x04 49 "67A4CB746083176B3F0196CFFF14C784")
(digest-bit-test 14 #x02 49 "B8326FCD6202593CFEEFEE4EBEF2A6D4")
(digest-bit-test 14 #x01 49 "7469B5EF25A906073CE985D8E9B6E3A6")
(digest-bit-test 15 #x80 48 "CADE494EF95747A696C914974F8529F9")
(digest-bit-test 15 #x40 48 "4C39AEF3783EDFB45FEDF0B24AA9C051")
(digest-bit-test 15 #x20 48 "FA04E0FBB65C7CCCD217547D03095F02")
(digest-bit-test 15 #x10 48 "54084EBCB91B8135981606FE7B96AB3B")
(digest-bit-test 15 #x08 48 "7ED51DDA7ED82A52AD83A25B3488E394")
(digest-bit-test 15 #x04 48 "271DD7546EB6E370058B1D2C8BF80749")
(digest-bit-test 15 #x02 48 "FE50CC119179A9D07548E39EB346A88A")
(digest-bit-test 15 #x01 48 "C4F54F5EAC3CE0368A804C9E271118BF")
(digest-bit-test 16 #x80 47 "46F0F8D5CC4F5DAEA65F083CDC60E1DB")
(digest-bit-test 16 #x40 47 "67D344764EC49EB384614BB8F32B4D07")
(digest-bit-test 16 #x20 47 "B524BF3E80AA6EDE797C8AC992CB06AE")
(digest-bit-test 16 #x10 47 "051B1B738DDD2F4704F7C56901879D6A")
(digest-bit-test 16 #x08 47 "D0337757E0A97C6F073FEE23B9338137")
(digest-bit-test 16 #x04 47 "41CF88BD76E6589EB3F779992BCC8646")
(digest-bit-test 16 #x02 47 "D2D1C2A673C7D26719EA7D06E54930F8")
(digest-bit-test 16 #x01 47 "0974DA79F1825FF4C0D96974460B1D78")
(digest-bit-test 17 #x80 46 "B3141AA98A4C3C52AE7BED0FB3E6DA02")
(digest-bit-test 17 #x40 46 "E955F5F222DFC412049CF0CB5DCDA8BA")
(digest-bit-test 17 #x20 46 "67FA38FCC938149E2434FDBF4094925A")
(digest-bit-test 17 #x10 46 "EF8ED24DCA3CE16EF463B9B4BF432F45")
(digest-bit-test 17 #x08 46 "0DE6EE7CDB1AB6DAB4244B0321177216")
(digest-bit-test 17 #x04 46 "8F584FC4B32AF8DD020240AE7CDEEBD7")
(digest-bit-test 17 #x02 46 "430939F51E8BB6A610C9E8B5F98D111A")
(digest-bit-test 17 #x01 46 "50E64EBBA2706F9D341879A04448EAA9")
(digest-bit-test 18 #x80 45 "42A07CE420358C8F6098396CE22CA993")
(digest-bit-test 18 #x40 45 "0D52BB5B089ABE136BB4AB593D03D57C")
(digest-bit-test 18 #x20 45 "5ED8617595F3200E7CF6B8326397AA00")
(digest-bit-test 18 #x10 45 "942754C7D535EF0EF553F5450125A831")
(digest-bit-test 18 #x08 45 "4587B8BFF1F599A478E4A428C19D5615")
(digest-bit-test 18 #x04 45 "1397C38048BCC3AA66B969077F1C62D2")
(digest-bit-test 18 #x02 45 "7A9DC04D89B0521D50D05CAAA83AE2EF")
(digest-bit-test 18 #x01 45 "A5D4603311C1970EC972AD190F0827C3")
(digest-bit-test 19 #x80 44 "DA6E4729A1911A639B3649CABCEC92F5")
(digest-bit-test 19 #x40 44 "EBF6599665AC5BEEA657C4E9F54C853A")
(digest-bit-test 19 #x20 44 "6BC6C2D4CD06FEF687D3C19C102AC435")
(digest-bit-test 19 #x10 44 "70BDFA5136C02554261EF1CBC266941D")
(digest-bit-test 19 #x08 44 "F788D088B95B7F560DC723E613053D82")
(digest-bit-test 19 #x04 44 "2E954672495564949E25C2207F68B2CC")
(digest-bit-test 19 #x02 44 "9AFD84C38D649CC61312C2892081CEE6")
(digest-bit-test 19 #x01 44 "3F59B60AD8ADAF8D15E35661B06C191F")
(digest-bit-test 20 #x80 43 "2A4451BF917B982FE6F2F611133D6145")
(digest-bit-test 20 #x40 43 "86219233D1CF5CC8461E7B7B67021258")
(digest-bit-test 20 #x20 43 "882C712BCD8333C7065B52DB7BC19A5A")
(digest-bit-test 20 #x10 43 "02A043BDB1922E81BD9ED074B5550C9B")
(digest-bit-test 20 #x08 43 "E95F2180F9BDA9680609B5DACC35D438")
(digest-bit-test 20 #x04 43 "76C05C78F0E28BD39BDEECB065DE31C8")
(digest-bit-test 20 #x02 43 "6413344601FD3B1E8539151B2F688A87")
(digest-bit-test 20 #x01 43 "5A6E81FC927131D1437C74DBC6BCD2C8")
(digest-bit-test 21 #x80 42 "16727D48488DC7B1C55028B9200DC96F")
(digest-bit-test 21 #x40 42 "24926A61E0810C361878588921E0E3A9")
(digest-bit-test 21 #x20 42 "0923DE3419F9F268C7C2A6D5DAD7D497")
(digest-bit-test 21 #x10 42 "8D598E2B0F8EEDB5B04E6A33D1CE98CC")
(digest-bit-test 21 #x08 42 "5AF6606098F0E22B3DD17BC1077A62E8")
(digest-bit-test 21 #x04 42 "62B5D8D3B14FE9C452BBF2AADF3B81EA")
(digest-bit-test 21 #x02 42 "43D78C46015F1AB109D2FE30052AAE6F")
(digest-bit-test 21 #x01 42 "B5ED66241DD79682BB0A9806EF662FC7")
(digest-bit-test 22 #x80 41 "619974CCD395FCFE5CF02FF3BA662315")
(digest-bit-test 22 #x40 41 "CDDE837F7461E55D0BF9A61DBC6801E1")
(digest-bit-test 22 #x20 41 "AB559653C6827C329338AD38FD747047")
(digest-bit-test 22 #x10 41 "A46FE12C4FBD38285B5FF154EBF80E61")
(digest-bit-test 22 #x08 41 "C9713B0A4429253231587565599FF94B")
(digest-bit-test 22 #x04 41 "75AEEFB4108210DFE68EFEB3AFB2E7AE")
(digest-bit-test 22 #x02 41 "D4282199C2600B098AF5CF4F6167A00C")
(digest-bit-test 22 #x01 41 "32054517D277F032998BFF444FE95DA2")
(digest-bit-test 23 #x80 40 "A49093F9C4F3C008CF08557BE76D27CD")
(digest-bit-test 23 #x40 40 "9C7806F3E44746AFE28513332D58F9A4")
(digest-bit-test 23 #x20 40 "EEC9CF74E56407537B797BAD535E164C")
(digest-bit-test 23 #x10 40 "7A4E8818E396894348A6BB9B9532621A")
(digest-bit-test 23 #x08 40 "8DABC9FE2D737DC37706C41B50575215")
(digest-bit-test 23 #x04 40 "34E835F14E4EC40343708E84EA163E8D")
(digest-bit-test 23 #x02 40 "4D8D1E037F329D64ED0752AAF0477AA7")
(digest-bit-test 23 #x01 40 "7497441DEB00A263D5335A132A4B8FA6")
(digest-bit-test 24 #x80 39 "4C599D8C2BD2572FB69C9A3FE69889AE")
(digest-bit-test 24 #x40 39 "4DE04150DC49AE121D39F3192B720575")
(digest-bit-test 24 #x20 39 "AC0EDA6732FAF6C03A0458A4E9637F83")
(digest-bit-test 24 #x10 39 "3B1D47A30271AFF9DA567FDA4BBBDF7C")
(digest-bit-test 24 #x08 39 "8E1A86357FF873D1C175C1C836F66364")
(digest-bit-test 24 #x04 39 "93E93726DC16D8557A49736880224619")
(digest-bit-test 24 #x02 39 "A4A8AADEF87556D60B5750C81048A2E7")
(digest-bit-test 24 #x01 39 "2398942DA53D994A7E4DD68F91676C72")
(digest-bit-test 25 #x80 38 "35A88E3124467CED6BF66BE8ABD96F93")
(digest-bit-test 25 #x40 38 "CADD29296AE24866EB9F6647B00820D9")
(digest-bit-test 25 #x20 38 "1D6636BCC96FB7A658168D36D8F5F457")
(digest-bit-test 25 #x10 38 "C92F5CAC84C30B3ABD69FCFA6B0661C6")
(digest-bit-test 25 #x08 38 "DF5FB3B4C2060A348F75E8E23881E195")
(digest-bit-test 25 #x04 38 "188AA80B6C337DF9D449B82B15986E3F")
(digest-bit-test 25 #x02 38 "9D737F50026D12240D4DB709B46D58E1")
(digest-bit-test 25 #x01 38 "8EEA8966AB0BFFE09EA95741E77496CE")
(digest-bit-test 26 #x80 37 "DD5C3855B1AFE1CB95F0B089D3EA4998")
(digest-bit-test 26 #x40 37 "15B441917B86443307ACBEB17903E28A")
(digest-bit-test 26 #x20 37 "8B9AC04A7359CAB27ECE8367E66EB1DD")
(digest-bit-test 26 #x10 37 "7706D55F0079CB4884358C6B4BCEA8DD")
(digest-bit-test 26 #x08 37 "2AABDD8E5BBBB2C71A5947EDA4E82250")
(digest-bit-test 26 #x04 37 "692E8799F4600207583CA843C28AF287")
(digest-bit-test 26 #x02 37 "7CF376D748E12F38AA598FABBA9CCBBE")
(digest-bit-test 26 #x01 37 "5CF3005A49D12B590F8D66651DEA3DD5")
(digest-bit-test 27 #x80 36 "832D8A7F23D849DE46AE6B242C7AB2CD")
(digest-bit-test 27 #x40 36 "C986FC62A1958C43A83C865FE58FEB0B")
(digest-bit-test 27 #x20 36 "42C81E6975949A88C1D290731A8D91CF")
(digest-bit-test 27 #x10 36 "D5C3F7DB76B70ACB2D61A5C7EAF57B63")
(digest-bit-test 27 #x08 36 "78B48D47312640F3B1B6E7168E051B5F")
(digest-bit-test 27 #x04 36 "D70E5706E48CBC4E89A7A03C9739A5BA")
(digest-bit-test 27 #x02 36 "7A83FB7A2EDCF2567534B2C6894597BE")
(digest-bit-test 27 #x01 36 "69EFEA0635D5E0DA3BB5E8DAC6450F15")
(digest-bit-test 28 #x80 35 "2CEF430452F547213E0060E439732BC9")
(digest-bit-test 28 #x40 35 "41504BD226814D1B8CE5A8E55BCEA2F2")
(digest-bit-test 28 #x20 35 "3B86CD11128F3E0CC02A6877BA972131")
(digest-bit-test 28 #x10 35 "DDC565ADB0FB192F8ECA2BA88A8A1617")
(digest-bit-test 28 #x08 35 "3BA992E7472A287F5443A4B7F2221248")
(digest-bit-test 28 #x04 35 "0FC4DC0CE3175D60460DE92ADAA30D2A")
(digest-bit-test 28 #x02 35 "D8CDD5ABF212C71965484392BC6C124B")
(digest-bit-test 28 #x01 35 "3A717676580551078A52BF501C600A30")
(digest-bit-test 29 #x80 34 "865C8091BACBCF8769BBA30B0D632F7B")
(digest-bit-test 29 #x40 34 "4DCFF6335B297771DF356997422BC0D4")
(digest-bit-test 29 #x20 34 "624302CC3FCCE2934535FBAF1569066D")
(digest-bit-test 29 #x10 34 "72B97C91164BC5B4B44ED53A641EA3E0")
(digest-bit-test 29 #x08 34 "93CE2501503C24AAF380273EC5CEFD1F")
(digest-bit-test 29 #x04 34 "ABF8F5DDE8FEC0150A1862E39F8D500E")
(digest-bit-test 29 #x02 34 "256ACF418C6EF3A796421D1915ED8361")
(digest-bit-test 29 #x01 34 "D52D6A384778AAE72B7BC381D32E9D1D")
(digest-bit-test 30 #x80 33 "ABA10D2AC6437B7D452D699174AF8804")
(digest-bit-test 30 #x40 33 "B5800387557A4F78044719FD8BD3473C")
(digest-bit-test 30 #x20 33 "AB949036594E0ECE4C24046D93E0D412")
(digest-bit-test 30 #x10 33 "43BFF184762DC63887F60148D76E48DC")
(digest-bit-test 30 #x08 33 "5D9AEC1DBF3F18CD12528436FF5FD2CF")
(digest-bit-test 30 #x04 33 "268560A41F44D97308C27C757899AD18")
(digest-bit-test 30 #x02 33 "831ED0FB77AE0A814D03475D679BDAF8")
(digest-bit-test 30 #x01 33 "B9D26E4AB351EFCD1092DE80967FFC1F")
(digest-bit-test 31 #x80 32 "F2A62DCF99199D49E6AEBE4F392D0C77")
(digest-bit-test 31 #x40 32 "A42FEB16940D4D7479D86A624999AD2A")
(digest-bit-test 31 #x20 32 "A5B27E702A3EDEE9946EC87E15F976BB")
(digest-bit-test 31 #x10 32 "BF0848C7D1B15D5229EBDC0B0BD038B3")
(digest-bit-test 31 #x08 32 "D2019E459B8E4F5B954AABAD128ECEFF")
(digest-bit-test 31 #x04 32 "A788071A087E7E4B6825F74CE8A8CADF")
(digest-bit-test 31 #x02 32 "2B4D686480A6379FC03D90AEB5C86F33")
(digest-bit-test 31 #x01 32 "E982708474DA81345710A20378CE2A67")
(digest-bit-test 32 #x80 31 "FF87F490B456AFE143452549C129D89E")
(digest-bit-test 32 #x40 31 "F69EAD65AED542643BC2560319978F38")
(digest-bit-test 32 #x20 31 "DBC4C1B2BB09B59D58DF6F4F62836922")
(digest-bit-test 32 #x10 31 "69C389886C0712456F69D0F9CF8F639F")
(digest-bit-test 32 #x08 31 "30BCD138CEBB7FDBA6E1F1381CD11F44")
(digest-bit-test 32 #x04 31 "9D996ADCCFC36B12FEFA2BE8CFABD95B")
(digest-bit-test 32 #x02 31 "CB406268152E14C548716F39352AC34F")
(digest-bit-test 32 #x01 31 "A0B04825CC109E4D76E007AA39BC6553")
(digest-bit-test 33 #x80 30 "8D73D3D813C14ED1C56898BA41ACCC26")
(digest-bit-test 33 #x40 30 "2F7321C9863B7D7379CAC8B127C00A42")
(digest-bit-test 33 #x20 30 "13984F531C0F8AB48AE74125EE65780A")
(digest-bit-test 33 #x10 30 "A610CE994AD741163460366002C4F319")
(digest-bit-test 33 #x08 30 "C65ED54BB67FE83D6F902D6544438C54")
(digest-bit-test 33 #x04 30 "013CF0DDF9A4C640D6B92CFE85B9860F")
(digest-bit-test 33 #x02 30 "B3762E84CB42EADE69453D81AD361A0A")
(digest-bit-test 33 #x01 30 "35340708EBA84A9D916F06E5C3D17FBA")
(digest-bit-test 34 #x80 29 "96EA5D98D41EB4C01A6AA81F98041427")
(digest-bit-test 34 #x40 29 "4C06D9489F80E0F3B12BE2519C75F5C0")
(digest-bit-test 34 #x20 29 "E46B367072C0C6686DFEB205D301DF82")
(digest-bit-test 34 #x10 29 "CDE9A045C3C57841CCDE5813DEB4275E")
(digest-bit-test 34 #x08 29 "BA8EC409FAD3F4A2ED51EE907BB5AC01")
(digest-bit-test 34 #x04 29 "DF72074C648A095D15EC6DADBF3C5925")
(digest-bit-test 34 #x02 29 "D6A4A77C409D399B571F39525C32A6CA")
(digest-bit-test 34 #x01 29 "91A1E9545A7429F3ACE04996DEB2A749")
(digest-bit-test 35 #x80 28 "40E2605929B2056A0E15EF339793B9A8")
(digest-bit-test 35 #x40 28 "C97528C25B98C098BDBAAD1B36BE3837")
(digest-bit-test 35 #x20 28 "D736C0CE9B37F201E25A8AEA4FEB7327")
(digest-bit-test 35 #x10 28 "9E353F7709472BA386A95EDCCF4827C4")
(digest-bit-test 35 #x08 28 "33E38ECB8F90F6D5BAA5EA7741202583")
(digest-bit-test 35 #x04 28 "F5E8DAD1164591B8E7E1680E5B0774C7")
(digest-bit-test 35 #x02 28 "31D22E6286675D1FB3FFE1FA39F9AC20")
(digest-bit-test 35 #x01 28 "9C362C0933D1212FB82530AEA8850980")
(digest-bit-test 36 #x80 27 "4F21AC13177670F938372E5C4F27F2CF")
(digest-bit-test 36 #x40 27 "EFE719571D6D7A40C9E59A25CCD1E332")
(digest-bit-test 36 #x20 27 "CA80D2DA774FBD460B1F9DE81DED27FA")
(digest-bit-test 36 #x10 27 "518913DBF627D354FC84240CD094A617")
(digest-bit-test 36 #x08 27 "BE2ADDC5E1985BAB750230CBF404E57F")
(digest-bit-test 36 #x04 27 "F25486DDFCCDC3A485FB1262FEECAE55")
(digest-bit-test 36 #x02 27 "CD66204F6D1F1F7D9D5B3515B2020830")
(digest-bit-test 36 #x01 27 "FF8AE245F0C57CF41EE804F02A50F6C4")
(digest-bit-test 37 #x80 26 "5B51221EF27C1EEF866035355890A5E4")
(digest-bit-test 37 #x40 26 "FE730AF0F19A1A5989CE0A09F4C0E183")
(digest-bit-test 37 #x20 26 "AFAC7BDAAB4EC1DD692433C6D0A7C03B")
(digest-bit-test 37 #x10 26 "6F2C2F536421C0B5692DA2D44C7FBD60")
(digest-bit-test 37 #x08 26 "51CD443D6EDBD2A9531AD8583631D31F")
(digest-bit-test 37 #x04 26 "FD673C736F07198D80FCC4504B5F6398")
(digest-bit-test 37 #x02 26 "814704B4D6E377F5E432A7AE335489D4")
(digest-bit-test 37 #x01 26 "265FB34FBC784919C7B8ADC667256F11")
(digest-bit-test 38 #x80 25 "D440BAE2B511C93CE93A29CF502FC418")
(digest-bit-test 38 #x40 25 "6DEA21BF7B854B7B483DBEB2960B0821")
(digest-bit-test 38 #x20 25 "89EB5F4BE9D4122A89012D675D284F7B")
(digest-bit-test 38 #x10 25 "063C5EE35961BAAC960FB49527AFC67D")
(digest-bit-test 38 #x08 25 "6082B4AACE19665A1D38B8DA2B79A17E")
(digest-bit-test 38 #x04 25 "04F028CA5F997AED87AF61BBB545C685")
(digest-bit-test 38 #x02 25 "12AE1D9B9B28CAA6CB087039EE8B25C8")
(digest-bit-test 38 #x01 25 "0C7B89B951ECB0C8BE2431FD742CEFE6")
(digest-bit-test 39 #x80 24 "4FBB360E60AE501CAB37E5A4F3E8C6D8")
(digest-bit-test 39 #x40 24 "EA31199F57786DA6D58D0B3BACBD668B")
(digest-bit-test 39 #x20 24 "ABA89F55D83F112F621A2501693A331E")
(digest-bit-test 39 #x10 24 "00956676DCF8138E1FEF0530C9E59FD0")
(digest-bit-test 39 #x08 24 "B932997CA40CF9D450056DE2E0234D38")
(digest-bit-test 39 #x04 24 "B0B54FDE61EC826AAF6941B301B9FA1D")
(digest-bit-test 39 #x02 24 "8FD8BC0F48BD80A5BD2B62C4800230B4")
(digest-bit-test 39 #x01 24 "E1B2A290E5C8F665A24B5DC022DDC12C")
(digest-bit-test 40 #x80 23 "8D915A468B1ADC4390DEAD2709CBFA9C")
(digest-bit-test 40 #x40 23 "335C558FEA3E913B1523204C628ACC5E")
(digest-bit-test 40 #x20 23 "D5F14992EF1BBD10438E6DE5A27222C6")
(digest-bit-test 40 #x10 23 "41D654B7B7DAD4AE3DE1FE69AB13A1B7")
(digest-bit-test 40 #x08 23 "DC4F2C360F492C0B98BA1A63A65EAA38")
(digest-bit-test 40 #x04 23 "4B2160C6735BDD1EA8112420414045AA")
(digest-bit-test 40 #x02 23 "BD2FDD88594F4A18AFD3BB660A77FA1F")
(digest-bit-test 40 #x01 23 "711CFCF659134FAD7333FF46119A01B0")
(digest-bit-test 41 #x80 22 "26191BE887BC1AFE51B6D3E92B4F88C9")
(digest-bit-test 41 #x40 22 "1E7B43A9C56DFFFAD29009D57F374145")
(digest-bit-test 41 #x20 22 "B83DE8AA13560F35120C01CDA26BA04A")
(digest-bit-test 41 #x10 22 "62A011815241418CD33BDA000E166087")
(digest-bit-test 41 #x08 22 "E04880B4DC587B9C6CE5A35408EC09D4")
(digest-bit-test 41 #x04 22 "107D1E02C9D5860D96170AC255AA67F5")
(digest-bit-test 41 #x02 22 "7C0AA11E779995FB585BDEF438CF9ACD")
(digest-bit-test 41 #x01 22 "5CC7953B35C35F8647EFFD9510E75A59")
(digest-bit-test 42 #x80 21 "78D8843516DFBB7508455EF5FA142B2D")
(digest-bit-test 42 #x40 21 "612B20B5C4F6BAE4F594E9F3F4A82FB3")
(digest-bit-test 42 #x20 21 "65D501D431B40185E3E63655EF12F6B7")
(digest-bit-test 42 #x10 21 "2F60CD131ABC3C637381D557B8B772DF")
(digest-bit-test 42 #x08 21 "D2035E9BB99D8D6135C86317C67490B3")
(digest-bit-test 42 #x04 21 "2599B6106634DDFFE1A6097239ED6327")
(digest-bit-test 42 #x02 21 "7155929319337413322F167CBA970CFC")
(digest-bit-test 42 #x01 21 "7DA0BC63FE503B3E0E4195DA5783EAC5")
(digest-bit-test 43 #x80 20 "EB22FC226396838D1A0242DCD75AE8D2")
(digest-bit-test 43 #x40 20 "64971E0FADC6912C387214F422D27268")
(digest-bit-test 43 #x20 20 "853B17C08A669B84345FD47C27FC64AB")
(digest-bit-test 43 #x10 20 "E5C9F54314498E87AF8F4F838D68C207")
(digest-bit-test 43 #x08 20 "38C8F547BCCC142B5488DEA99D2FD15B")
(digest-bit-test 43 #x04 20 "7890E5E8CFEB171F92E901E2BFF49DEF")
(digest-bit-test 43 #x02 20 "134FADF68897B0AAED3D138A5E73B457")
(digest-bit-test 43 #x01 20 "655555A93CEC20854AB16BC9A2EE12E1")
(digest-bit-test 44 #x80 19 "113CCE04855767F7ECCABAC3AB9DBC4C")
(digest-bit-test 44 #x40 19 "8DCABDD80D6891AE82D27A62CA5CBFDC")
(digest-bit-test 44 #x20 19 "B55E241BD6E6F1EFEEA94DACED298082")
(digest-bit-test 44 #x10 19 "A986C1E46876C5B79876FEE689007EF8")
(digest-bit-test 44 #x08 19 "8FDF2D086D8EA0EF2BD4BFB626C8065F")
(digest-bit-test 44 #x04 19 "0018C4C92548087707886B19B9B6DEB5")
(digest-bit-test 44 #x02 19 "A6A8D3FC4596E65CA9A9474E845B4482")
(digest-bit-test 44 #x01 19 "19372E51D0E1FFDD658ED1768C9951C4")
(digest-bit-test 45 #x80 18 "3AFEC090447E3E8ECFE9A36DA12A9C4A")
(digest-bit-test 45 #x40 18 "AA7A63CE7C642387AB142F3C368F4DAC")
(digest-bit-test 45 #x20 18 "67743320502FCC66B7B054C636554F13")
(digest-bit-test 45 #x10 18 "8812200381A08D93260BB16D3C7B8053")
(digest-bit-test 45 #x08 18 "30A2A0AC2059F43F822738FE41B64392")
(digest-bit-test 45 #x04 18 "71F1169342B7E47057F10AE0C514ABDB")
(digest-bit-test 45 #x02 18 "A27E2D60772D8EA0C576D439F38CB7FD")
(digest-bit-test 45 #x01 18 "AD2D997DF99283C0088ACA0CFA939B6A")
(digest-bit-test 46 #x80 17 "1574271BB22E22A26D5E4025F8CA3BE0")
(digest-bit-test 46 #x40 17 "0E6593CF9CBE2E5FD9459D4E25FC8808")
(digest-bit-test 46 #x20 17 "921D0D98FEE2FD0FAE77BBE8CEE75C4C")
(digest-bit-test 46 #x10 17 "330DBD27827948BF7854AD8F770EA413")
(digest-bit-test 46 #x08 17 "193F2E38A7E001DC2B132153E86C3170")
(digest-bit-test 46 #x04 17 "AB0F8A360190725F0DB386511FA16688")
(digest-bit-test 46 #x02 17 "522884031569527E0EA2CD59FF2AFAE6")
(digest-bit-test 46 #x01 17 "A70526A45C6204AED6F872AFE0C2030F")
(digest-bit-test 47 #x80 16 "2929A46F1243345745BE5F0CEFFFEA9D")
(digest-bit-test 47 #x40 16 "A1C2FE4D26AD58FC32025C2BDE0B8F53")
(digest-bit-test 47 #x20 16 "49F7F1239B65A00C79B833102DEA4470")
(digest-bit-test 47 #x10 16 "D715B83A7C045EA5DE1A1014D3C388E0")
(digest-bit-test 47 #x08 16 "C5B9DC3AF4F82C4A0EEB9FD5A3CA71AE")
(digest-bit-test 47 #x04 16 "990130C05319F8CCCDFC295F13D0B51E")
(digest-bit-test 47 #x02 16 "58D52BCD0D981839F438371952F76FE4")
(digest-bit-test 47 #x01 16 "A7167C368E85068EC798C8242D97B9B5")
(digest-bit-test 48 #x80 15 "BCCCC2A040780B8634A160077A0518B6")
(digest-bit-test 48 #x40 15 "217F09C5C7D9C35370A20293FA48BE64")
(digest-bit-test 48 #x20 15 "7E100CAD7A0BCD1F1F91426009E5035C")
(digest-bit-test 48 #x10 15 "9937ECE33144619A1B4C06B3B5D958C1")
(digest-bit-test 48 #x08 15 "B81C377C685216B65060E496E20DD1AE")
(digest-bit-test 48 #x04 15 "95E6F4F0EA2E1D9BFA0CB30CFCEB82C1")
(digest-bit-test 48 #x02 15 "40C3B24318632EC9640F3F0C8E561C84")
(digest-bit-test 48 #x01 15 "EED48C469E07EE625615E3D75949740A")
(digest-bit-test 49 #x80 14 "E7F28F14BE306A1C8B1A01280878F0F1")
(digest-bit-test 49 #x40 14 "373585DF43F020AACB6061A95D7A3D04")
(digest-bit-test 49 #x20 14 "3B400E497AFFB8C308A953E70EA4C9DC")
(digest-bit-test 49 #x10 14 "8E28C7D91C8C70E44D201FCA8264C6D0")
(digest-bit-test 49 #x08 14 "106A08239964D83046F4BC5C6FC5D292")
(digest-bit-test 49 #x04 14 "BE99DB37B00BF454B7FD234FA38325FB")
(digest-bit-test 49 #x02 14 "E60BDC54B53931474DACC0F938EAFB82")
(digest-bit-test 49 #x01 14 "AD49039B927F3255746F5F8B29D026BC")
(digest-bit-test 50 #x80 13 "243B1CA9BB302073C43D2034D1701008")
(digest-bit-test 50 #x40 13 "51D708A3EC669C4AEAE962B7002E84AB")
(digest-bit-test 50 #x20 13 "3C3C48C8FECE87A8244A812EB30103D7")
(digest-bit-test 50 #x10 13 "62FCEBD1322730F36609C0B71F013977")
(digest-bit-test 50 #x08 13 "A40079DD041D39E7F286D4C074319A88")
(digest-bit-test 50 #x04 13 "4CE8D48695094B9ED177C32D84490C64")
(digest-bit-test 50 #x02 13 "239CB4F2D9DAF02880590639D9473D72")
(digest-bit-test 50 #x01 13 "42BEECDFE7ED6721E3D746AD9ADF60D8")
(digest-bit-test 51 #x80 12 "6637254EB223AEF1E0070CE24D150A42")
(digest-bit-test 51 #x40 12 "EC1C0EFB06D494F5929170230EA29F8B")
(digest-bit-test 51 #x20 12 "06E20B68CD82553945F588CF3B072228")
(digest-bit-test 51 #x10 12 "4C935F8067F9E89002F664E32310D653")
(digest-bit-test 51 #x08 12 "65F609AA81C427B2461DE2E87F19232D")
(digest-bit-test 51 #x04 12 "130CB2489827F80099188772A1E297A7")
(digest-bit-test 51 #x02 12 "FF2870DAC9CEBF2C00EAF9C7397A84AF")
(digest-bit-test 51 #x01 12 "965BEFA150B21B023476934CE2F4DD48")
(digest-bit-test 52 #x80 11 "4748E12C9B9B027C2FD250A7BF75D404")
(digest-bit-test 52 #x40 11 "3C22EE69FAA79253E66276B9BFAB6E7F")
(digest-bit-test 52 #x20 11 "F915A8F4EF3CEEF1239E8EA00A08FDC0")
(digest-bit-test 52 #x10 11 "5E9BE5E6AECD61AACAD27B71C219A4FF")
(digest-bit-test 52 #x08 11 "B90EA5FCECE69767CB22ACA0322F8182")
(digest-bit-test 52 #x04 11 "B03FC9B6458121630E1E12425BDE2B76")
(digest-bit-test 52 #x02 11 "4C0C22304A32242DE23C0952251625D7")
(digest-bit-test 52 #x01 11 "BDD58B71E31A4537F8CBDAB9E4EA2823")
(digest-bit-test 53 #x80 10 "3BC207A83DEBCAE9DB19C67881A2907D")
(digest-bit-test 53 #x40 10 "17ABC23A3B7C5C3F4238B4C9B60393FB")
(digest-bit-test 53 #x20 10 "990ADD29BBEEA26D36FBE9FAEE480DE0")
(digest-bit-test 53 #x10 10 "E739B36FB27CD07EF63C1DEA5F05C2B5")
(digest-bit-test 53 #x08 10 "6C2ABCD513756454FD8EFF7C05C347D9")
(digest-bit-test 53 #x04 10 "714C165F1098665831F20C3CCACC786B")
(digest-bit-test 53 #x02 10 "A4297212FE643FE7585B61B0CA54501E")
(digest-bit-test 53 #x01 10 "CC1F3F9C967BB3D518F17CB917AF3541")
(digest-bit-test 54 #x80 9 "7CBDDD340A9EDB15E9764C8D0C5CAC82")
(digest-bit-test 54 #x40 9 "CBEA87EAD6F2861A1A976B0094CEC936")
(digest-bit-test 54 #x20 9 "2BA194132EE5196988287217E16CA218")
(digest-bit-test 54 #x10 9 "8A9B3CB20F1F3F9A5B25F51A2744C593")
(digest-bit-test 54 #x08 9 "6E379119BBD6CB8956568EB2EAF3CF16")
(digest-bit-test 54 #x04 9 "6B3B3AF07FF6CCFA55326CF74CE1BE12")
(digest-bit-test 54 #x02 9 "58CC216A7E8B1B520B914A42CD77A95C")
(digest-bit-test 54 #x01 9 "62D402575E31D8F00A24829ABB4FB735")
(digest-bit-test 55 #x80 8 "27AB445A2D2F6AE41D0BC60AEFC8D8FD")
(digest-bit-test 55 #x40 8 "3780B0F8539BF4B4BF650149C0219323")
(digest-bit-test 55 #x20 8 "0C12ACE64B7B880FE86AE3930B5C923B")
(digest-bit-test 55 #x10 8 "30EA9812001F376C52AA8BF2A8803258")
(digest-bit-test 55 #x08 8 "00A77BBA134EC7F048495CC221D0C1AC")
(digest-bit-test 55 #x04 8 "91548EE3EC1175D8408610CED2DE1D61")
(digest-bit-test 55 #x02 8 "90A3AEB7EE1BEFC671B1E3974694814F")
(digest-bit-test 55 #x01 8 "BF4EA65FF974E5864DE084172A42BE94")
(digest-bit-test 56 #x80 7 "101087341122D53A5C9C39A14486FBD1")
(digest-bit-test 56 #x40 7 "8AC7E1D8C4B6C5D0D7E8AE04C99A5AEB")
(digest-bit-test 56 #x20 7 "FDD1A742B9A53720A83D13BBB52E6B59")
(digest-bit-test 56 #x10 7 "7074A3E598C6CB6B729953D1912EDE8F")
(digest-bit-test 56 #x08 7 "3BCCA8F88026DA33A85EBEA0D92085E7")
(digest-bit-test 56 #x04 7 "8C39347BE5FFEEB436720E7B62F95AB7")
(digest-bit-test 56 #x02 7 "2A8D32E9D57BCA170A314E10EB2E14D9")
(digest-bit-test 56 #x01 7 "AEBA2E5DFA53D0866C670EC2DF9BAEFA")
(digest-bit-test 57 #x80 6 "76C4B1546EFE5FE4CE780D88F45112C6")
(digest-bit-test 57 #x40 6 "B2C9982B2BB69CF1F803E4FB721EE594")
(digest-bit-test 57 #x20 6 "6064131C8D0045906C3A4AC95CEA9850")
(digest-bit-test 57 #x10 6 "A573132EB414900A6F2D145054ED9B71")
(digest-bit-test 57 #x08 6 "BD3803EBAF57D1D59D2E344B95C95DBA")
(digest-bit-test 57 #x04 6 "97679B799CE10FF731F1B036F300261F")
(digest-bit-test 57 #x02 6 "045FA3ED64892236889D890D70F88297")
(digest-bit-test 57 #x01 6 "EDFEF1B83D497F241AFCAD2670766550")
(digest-bit-test 58 #x80 5 "5044776204D1D991CB6D039F3CE639A6")
(digest-bit-test 58 #x40 5 "E3C3A88841C4486991BD684C482F468F")
(digest-bit-test 58 #x20 5 "204B0EED4092ED3CD041555213C7016E")
(digest-bit-test 58 #x10 5 "AA181AEB0883C2EB1517546F05DCF5A1")
(digest-bit-test 58 #x08 5 "0776CD1285638E99C9F92B67DFE3A93B")
(digest-bit-test 58 #x04 5 "41F545E21F35D1C76D35F46AF08D1AC3")
(digest-bit-test 58 #x02 5 "5C0027928ACEA6E8764992BB53D9A200")
(digest-bit-test 58 #x01 5 "9F764E6504EEB62D6F7B0551CFEB32C5")
(digest-bit-test 59 #x80 4 "65A182D7F3C3551DB2EB9A589C2BC154")
(digest-bit-test 59 #x40 4 "E1D3D40E72D89A16E985A7D6D45B2BD6")
(digest-bit-test 59 #x20 4 "4DE48F8B3A984A17D9871D4D7394DD96")
(digest-bit-test 59 #x10 4 "A616A4C01CB1CB5AC0B170AC7F295C81")
(digest-bit-test 59 #x08 4 "D57E28E6A20EB1E605FC1185796FD76A")
(digest-bit-test 59 #x04 4 "5162808EB7C844045397AAE6A9FD579A")
(digest-bit-test 59 #x02 4 "C02D9BA7FD05719313649E4A9C4B377F")
(digest-bit-test 59 #x01 4 "7EDE5C243C23AAC804CF2B9CD82A9B4E")
(digest-bit-test 60 #x80 3 "08FA1E2DEB8C28C84D3501C6490C8299")
(digest-bit-test 60 #x40 3 "98E814F0BCB5BB2E0C4CECF0E456ED66")
(digest-bit-test 60 #x20 3 "D5F234F232A16CA09403113659DF5940")
(digest-bit-test 60 #x10 3 "11B36584307FA2026A1EF1FB2F923E53")
(digest-bit-test 60 #x08 3 "20EFCB7687C857E2DB86AD61E9EB64F0")
(digest-bit-test 60 #x04 3 "52961A3E3F4D807B17924B945D0EF0BA")
(digest-bit-test 60 #x02 3 "AE39BED8D20A0BAEE477D53C4388247B")
(digest-bit-test 60 #x01 3 "E73B87F8A3FB962D7F8B6E5724FBB394")
(digest-bit-test 61 #x80 2 "43A7ED379BEFB67B5A757726B36FAF03")
(digest-bit-test 61 #x40 2 "04E387CD2BABD6ED2A581CE0D35CA2C4")
(digest-bit-test 61 #x20 2 "C3E46CCE582699F849E852D8CC72786B")
(digest-bit-test 61 #x10 2 "E511DC2C83118F52DBC80330DF1F44D7")
(digest-bit-test 61 #x08 2 "04D1B43C3ED99FC2A59DA3462142E070")
(digest-bit-test 61 #x04 2 "D4C0D26CE697D58ACE25AC2D9FFA99BD")
(digest-bit-test 61 #x02 2 "46479C1ED1572FD54099CE935E03A509")
(digest-bit-test 61 #x01 2 "8856F192CE9E7FEA0FDC5F5C2FEAA54E")
(digest-bit-test 62 #x80 1 "ED72DED2FF418F23A7CC250E3607AF66")
(digest-bit-test 62 #x40 1 "055F5FE4A2376F94EE6CFB892F083AF1")
(digest-bit-test 62 #x20 1 "E587BC51D8CC4CDBB72B615C7DBE2F19")
(digest-bit-test 62 #x10 1 "886FC0C898EEB8A3FA34A62D9CD9EE3E")
(digest-bit-test 62 #x08 1 "5CE1643888E280FC6AEA24EB4E7484C5")
(digest-bit-test 62 #x04 1 "E28C5C0C011898C183595262938E7AD3")
(digest-bit-test 62 #x02 1 "FBCD570FF301F37DB9B59DA5290ACCF9")
(digest-bit-test 62 #x01 1 "EEB3F6127C385A4CF0001A0482E7B5AD")
(digest-bit-test 63 #x80 0 "C0765C537B427E59CCCA837A101C82A5")
(digest-bit-test 63 #x40 0 "C7DA8C6B49A6679F620552876BCFE9AA")
(digest-bit-test 63 #x20 0 "EF6FD22A2F3D55B935F7E7842E9A563E")
(digest-bit-test 63 #x10 0 "A44C909A87C3EB6201888A92FEBFC1DB")
(digest-bit-test 63 #x08 0 "1A2A32D70B2328B8AEDAABF0BBE80190")
(digest-bit-test 63 #x04 0 "083F164EA0D8BDB2CE5D18A187792BAA")
(digest-bit-test 63 #x02 0 "01A1F51997AD4AF2A6652517B7FFB9DC")
(digest-bit-test 63 #x01 0 "F43AF6AEC164C17A6DCDCD7D460B093D")
