////
///  genfisuffix - a Finnish affix table generator for ispell
//   Copyright (C) 2000  Pauli Virtanen <pauli.virtanen@saunalahti.fi>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//   The program's output is also subject to this license, and considered
//   program source code.
//
//////////////////////////////////////////////////////////////////////////////
//
//
#ifndef GENFISUFFIX_HH_
#define GENFISUFFIX_HH_

#include <vector>
#include <string>

//////////////////////////////////////////////////////////////////////////////
///
/// Options
///
typedef struct options_t
{
        bool use_suffix_particles;
        bool use_all_suffix_particles;
        bool use_possessive_suffixes;
} options_t;

extern options_t options;


//////////////////////////////////////////////////////////////////////////////
///
/// Helper function prototypes
/// 
string ucase(const string &str);
string lcase(const string &str);
void output_suffix(const string &pattern, const string &replaced,
                   const string &replacement);
void output_suffix_group(const string &pattern, const string &replaced,
                         const vector<string> &replacements);
vector<string> suffix_strings(const vector<string> &strings,
                              const vector<string> &suffixes);
vector<string> prefix_strings(const vector<string> &strings,
                              const vector<string> &prefixes);
vector<string> suffix_strings(const vector<string> &strings,
                              const string &suffix);
vector<string> prefix_strings(const vector<string> &strings,
                              const string &prefix);
void add_to_vector(vector<string> &vect, const vector<string> &to_add);
vector<string> generate_n_possessive_suffix(const vector<string> &strs);

string do_tr(const string &str, const char *from, const char *from_end,
             const char *to, const char *to_end);
string to_front_vowel(const string &strs);
string to_back_vowel(const string &strs);
vector<string> to_front_vowel(const vector<string> &strs);
vector<string> to_back_vowel(const vector<string> &strs);
void add_list_to_vector(vector<string> &vect, const char *list[]);
void output_flag(const char flag);
vector<string> combine(const vector<string> &v1, const vector<string> &v2);
vector<string> combine(const vector<string> &v1, const vector<string> &v2,
                       const vector<string> &v3);
vector<string> new_list(const char *const str, ...);
vector<string> add_and_suffix(const vector<string> which,
                              const vector<string> suffixes);

///
/// Outputting lists of suffixes
///
struct Suffix
{
        Suffix(string p, string r, string m)
                        : pattern(p), replaced(r)
                { replacements.push_back(m); }
        Suffix(string p, string r, vector<string> m)
                        : pattern(p), replaced(r), replacements(m)
                {}

        string pattern;
        string replaced;
        vector<string> replacements;
};

void output_suffix_list(Suffix *lst, int n);
void output_suffix_list_to_front(Suffix *lst, int n);

#endif
