/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: hal_psi.h,v 1.3 2005/05/12 01:42:34 ro_han Exp $
 *****************************************************************************/

#include "common.h"

// The following are some functions which make working with HAL PSIs somewhat simpler.

// Returns the type of a property.
LibHalPropertyType psi_get_property_type(LibHalPropertySet * set,
                                         char const *const key);

// Returns whether or not a certain property exists.
dbus_bool_t psi_property_exists(LibHalPropertySet * set,
                                char const *const key);

// For all of the below functions, preconditions are:
// 1) the property exists (use psi_property_exists to check)
// 2) the property is of the necessary type (use psi_get_property_type to check)

char *psi_get_property_string(LibHalPropertySet * set,
                              char const *const key);
dbus_bool_t psi_get_property_bool(LibHalPropertySet * set,
                                  char const *const key);
dbus_int32_t psi_get_property_int(LibHalPropertySet * set,
                                  char const *const key);
dbus_uint64_t psi_get_property_uint64(LibHalPropertySet * set,
                                      char const *const key);
