#ifndef _JACK_C
#define _JACK_C

#include <stdio.h>
#include <jack/jack.h>

jack_client_t *
xjack_client_new ( const char *name )
{
  jack_client_t *client = jack_client_new ( name ) ;
  if ( ! client ) {
    fprintf ( stderr , "jack_client_new() failed: %s\n" , name ) ;
    FAILURE ;
  }
  return client ;
}

void
jack_minimal_error_handler ( const char *desc )
{
  fprintf ( stderr , "jack error: %s\n" , desc ) ;
}

void
jack_minimal_shutdown_handler ( void *arg )
{
  fprintf ( stderr , "jack shutdown\n") ;
  FAILURE ;
}

int 
xjack_activate ( jack_client_t *client )
{
  int err = jack_activate ( client ) ;
  if ( err ) {
    fprintf ( stderr , "jack_activate() failed\n" ) ;
    FAILURE ;
  }
  return err ;
}

#endif
