#ifndef _DRAW_SIGNAL_C
#define _DRAW_SIGNAL_C

#include "img.c"
#include "signal.c"

void
jackscope_draw_signal_init ( uint8_t *image , int size )
{
  int i ;
  for ( i = 0 ; i < size ; i+=3 ) {
    uint8_t half[3] = { 128 , 128 , 128 } ;
    uint8_t feint[3] = { 192 , 192 , 192 } ;
    img_set_pixel_xy ( image , size , i , size/2 , half ) ;
    img_set_pixel_xy ( image , size , i , size/6 , feint ) ;
    img_set_pixel_xy ( image , size , i , size-(size/6) , feint ) ;
  }
}

void
jackscope_draw_signal_data ( uint8_t *image , int size , const float *signal , int n , const uint8_t *color , int style )
{
  int i ;
  float incr = (float)n / (float)size ;
  float index = 0.0 ;
  for ( i = 0 ; i < size ; i++ ) {
    float s = signal_interpolate_safe ( signal , n , index ) ;
    int y = signal_y_to_screen_y ( s , size ) ;
    index += incr ;
    img_set_pixel_xy ( image , size , i , y , color ) ;
    if ( style == DOT_STYLE ) {
      img_set_pixel_xy ( image , size , i , y , color ) ;
    } else if ( style == FILL_STYLE ) {
      int m = size / 2 ;
      int l = y > m ? m : y ;
      int r = y > m ? y : m ;
      int j ;
      for ( j = l ; j < r ; j++ ) {
	img_set_pixel_xy ( image , size , i , j , color ) ;
      }
    } else if ( style == LINE_STYLE ){
      float ss = signal_interpolate_safe ( signal , n , index ) ;
      int yy = signal_y_to_screen_y ( ss , size ) ;
      int l = yy > y ? y : yy ;
      int r = yy > y ? yy : y ;
      int j ;
      for ( j = l ; j < r ; j++ ) {
	img_set_pixel_xy ( image , size , i , j , color ) ;
      }
    }  
  }
}

void
jackscope_draw_signal ( uint8_t *image , int size , const float *signal , int f , int d , int c , const uint8_t *color , int style )
{
  jackscope_draw_signal_init ( image , size ) ;
  int i ;
  for ( i = 0 ; i < c ; i++ ) {
    jackscope_draw_signal_data ( image , size , signal + ( i * f ) , d , color + ( i * 3 ) , style ) ;
  }
}

#endif
