#ifndef _REGEX_C
#define _REGEX_C

#include <regex.h>
#include <stdio.h>

#ifndef FAILURE
#define FAILURE exit(1)
#endif

static int 
xregcomp ( regex_t *preg , const char *regex , int cflags ) 
{
  int err = regcomp ( preg , regex , cflags ) ;
  if ( err ) {
    char str[64];
    regerror ( err , preg , str , 64 ) ;
    fprintf ( stderr , "regcomp() failed on `%s' with `%d': %s\n" , regex , cflags , str ) ;
    FAILURE ;
  }
}

static int 
xregexec( const regex_t *preg , const char *string , size_t nmatch ,
	  regmatch_t pmatch[] , int eflags )
{
  return regexec ( preg , string , nmatch , pmatch , eflags ) ;
}

#endif
