#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
 #include <unistd.h>
#endif
#ifdef HAVE_PTHREAD_H
 #include <pthread.h>
#endif
#ifdef HAVE_WIN32COMPAT_H
 #include <win32compat.h>
#endif
#ifdef HAVE_SYS_TIMEB_H
 #include <sys/timeb.h>
#endif

#include <jmp.h>
#include <comparators.h>
#include <deadlock_detector.h>

#include <ui_none.h>
#ifdef CONFIG_UI_FILE
 #include <ui_file.h>
#endif

/** This file implements the ui interface. 
 *  The ui provided by this file is: none, dumping to file works.
 *
 *  Some methods are marked with "This method does nothing." 
 *  Thoose methods are only here to enable the no-ui to link correctly.
 */

/** state tokens:
 * -2 embrionic
 * -1 startup UI running
 * 0  normal
 * 2  shutdown UI requested
 * 3  shutdown UI running
 * 4  shutdown UI completed
 */
static int quit = -2;
#ifdef SUPPORT_PTHREAD
static PTHREAD_MUTEX_T(quit_mutex);
static PTHREAD_COND_T(quit_cond);
#else
static JVMPI_RawMonitor quit_monitor;
static void *quit_cond;
static void *quit_mutex;
static const char *MONITOR_NAME_QUIT = "_jmp_quit";
#endif

#if __unused__
static int checkShutdownUI (void) {
    int rv = 0;
    PTHREAD_MUTEX_LOCK (quit_mutex);
    if (quit != 0)
        rv = 1;
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    return rv;
}
#endif

static int checkThenDoShutdownUI (void) {
    int rv = 0;
    PTHREAD_MUTEX_LOCK (quit_mutex);
    if (quit == 1) {
        /* time to shut down. */
        quit = 2;
        PTHREAD_COND_BROADCAST (quit_cond);
        rv = 1;
    } else if (quit != 0) {
        rv = 1;
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    return rv;
}

static int ui_state (int below, int set) {
    int rv = 0;
    PTHREAD_MUTEX_LOCK (quit_mutex);
    if (quit <= below) {
        if (quit == below) {
            quit = set;
            PTHREAD_COND_BROADCAST (quit_cond);
            rv = 1;
        }
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    return rv;
}

int run_updates (void* data) {
    if (checkThenDoShutdownUI())
        return 0;

#ifdef CONFIG_UI_FILE
    dumptimer_tick();
#endif

    return 1;
}

void end_ui (void) {
    PTHREAD_COND_DESTROY (quit_cond);
    PTHREAD_MUTEX_DESTROY (quit_mutex);
}

void init_ui (void) {
    int res;
    PTHREAD_MUTEX_INIT (quit_mutex, NULL, MONITOR_NAME_QUIT, &res);
    PTHREAD_COND_INIT (quit_cond, NULL);
    quit = 0;
}

void start_ui (void) {
    /* do nothing. */
}

void stop_ui (void) {
    /* do nothing. */
}

void ask_stop_ui (void) {
    /* do nothing. */
}

#ifdef WIN32
void gtkthread (void* data) {
    int loop = 1;

    PTHREAD_MUTEX_LOCK (quit_mutex);
    for (;;) {
        if (quit >= -1)
            break;		/* UI can startup */
        PTHREAD_COND_TIMEDWAIT (quit_cond, quit_mutex, NULL);
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);

    ui_state (-1, 0);

    PTHREAD_MUTEX_LOCK (quit_mutex);
    while (loop) {
        struct timeb waituntil;
        struct timeb timebuffer;

        PTHREAD_MUTEX_UNLOCK (quit_mutex);
	run_updates (NULL);

	ftime (&timebuffer);
	memcpy (&waituntil, &timebuffer, sizeof(waituntil));
        waituntil.time += 1;
        PTHREAD_MUTEX_LOCK (quit_mutex);
        for (;;) {
            if (quit >= 1) {
                loop = 0;
                quit = 3;
                PTHREAD_COND_BROADCAST (quit_cond);
                break;
            }
            if (PTHREAD_COND_TIMEDWAIT (quit_cond, quit_mutex, &waituntil) != 0)
                break;
        }
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    ui_state (3, 4);
}

/** Tell the ui system to shut itself down. */
int quit_ui (void) {
    if (ui_state (0, 2) || ui_state (1, 2))
        checkThenDoShutdownUI ();

    PTHREAD_MUTEX_LOCK (quit_mutex);
    {
        struct timeb waituntil;
        struct timeb timebuffer;

        PTHREAD_MUTEX_UNLOCK (quit_mutex);

	ftime (&timebuffer);
	memcpy (&waituntil, &timebuffer, sizeof(waituntil));
        waituntil.time += 5;
        PTHREAD_MUTEX_LOCK (quit_mutex);
        for (;;) {
            if (quit >= 4)
                break;		/* UI has shutdown */
            if (PTHREAD_COND_TIMEDWAIT (quit_cond, quit_mutex, &waituntil) != 0) {
                fprintf (stderr, "ERROR: UI thread shutdown timeout after 5 seconds\n");
                break;
            }
        }
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    return 0;
}
#else
void gtkthread (void* data) {
    int loop = 1;
    PTHREAD_MUTEX_LOCK (quit_mutex);
    while (loop) {
        struct timespec timespec;
        struct timeval timeval;

        PTHREAD_MUTEX_UNLOCK (quit_mutex);
	run_updates (NULL);

        gettimeofday(&timeval, NULL);
        timespec.tv_sec = timeval.tv_sec + 1;
        timespec.tv_nsec = timeval.tv_usec * 1000;
        PTHREAD_MUTEX_LOCK (quit_mutex);
        for (;;) {
            if (quit >= 1) {
                loop = 0;
                quit = 3;
                PTHREAD_COND_BROADCAST (quit_cond);
                break;
            }
            if (PTHREAD_COND_TIMEDWAIT (quit_cond, quit_mutex, &timespec) != 0)
                break;
        }
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    ui_state (3, 4);
}

/** Tell the ui system to shut itself down. */
int quit_ui (void) {
    if (ui_state (0, 2) || ui_state (1, 2))
        checkThenDoShutdownUI ();

    PTHREAD_MUTEX_LOCK (quit_mutex);
    {
        struct timespec timespec;
        struct timeval timeval;

        PTHREAD_MUTEX_UNLOCK (quit_mutex);

        gettimeofday(&timeval, NULL);
        timespec.tv_sec = timeval.tv_sec + 5;
        timespec.tv_nsec = timeval.tv_usec * 1000;
        PTHREAD_MUTEX_LOCK (quit_mutex);
        for (;;) {
            if (quit >= 4)
                break;		/* UI has shutdown */
            if (PTHREAD_COND_TIMEDWAIT (quit_cond, quit_mutex, &timespec) != 0) {
                fprintf (stderr, "ERROR: UI thread shutdown timeout after 5 seconds\n");
                break;
            }
        }
    }
    PTHREAD_MUTEX_UNLOCK (quit_mutex);
    return 0;
}
#endif


/** Update the statistics. */
void updateUI (hashtab* cls, hashtab* methods) {
}


/** Set the status text... */
void set_status (const char* text) {
}

/** Check if we have any ui-handling to do. */
int events_pending (void) {
    return 0;
}

/** Update the ui-toolkit (gtk_main_iteration ()) */
int ui_iteration (void) {
    return 0;
}

void show_deadlock (visited_threads* vt) {
    while (vt != NULL) {
	fprintf (stdout, "%s holding %s (%p)", 
		 jmpthread_get_thread_name (vt->mi->owner), 
		 vt->mi->name, vt->mi->id); 
	if (vt->next) 
	    fprintf (stdout, ", trying to enter %s (%p)\n", 
		     vt->next->mi->name, vt->next->mi->id);
	else 
	    fprintf (stdout, "\n");
	vt = vt->next;
    }
}

void notify_profile_window_begin_ui (void) { }
void notify_profile_window_end_ui (void) { }
void notify_profile_window_close_ui (void) { }
void notify_jvm_shutdown_ui (void) { }
void notify_update_full_try_ui (void) { }

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
