#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <obj.h>

obj* obj_new (jint arena_id, cls* class_id, jint is_array,
	      jint size, jobjectID obj_id, method* method,
	      int reset_level, int gc_level) {
    obj* o = malloc (sizeof (*o));
    if (o == NULL)
	return NULL;
    o->arena_id = arena_id;
    o->clz = class_id;
    o->is_array = is_array;
    o->size = size;
    o->obj_id = obj_id;
    o->method = method;
    o->reset_level = reset_level;
    o->gc_level = gc_level;
    return o;
}

void obj_free (obj* c) {
    free (c);
}

size_t obj_jmphash_func (void* c, size_t len) {
    obj* o = (obj*)c;
    return ((long)o->obj_id) % len;
}

int obj_cmp_func (void* c1, void* c2) {
    obj* o1 = (obj*)c1;
    obj* o2 = (obj*)c2;
    if (o1 == NULL || o2 == NULL)
	return 1;    
    return o1->obj_id != o2->obj_id; 
} 

void obj_print (obj* o) {
    fprintf (stdout, "OBJECT (%p): arena: %d, class_id: %p, is_array: %d, size: %d, obj_id: %p\n", 
	     o, PRINTF_JINT_CAST o->arena_id, cls_get_class_id (o->clz),
	     PRINTF_JINT_CAST o->is_array, PRINTF_JINT_CAST o->size, o->obj_id);
}

INLINE jobjectID obj_get_object_id (obj* o) {
    return o->obj_id;
}

INLINE void obj_set_object_id (obj* o, jobjectID obj_id) {
    o->obj_id = obj_id;
}

INLINE cls* obj_get_class (obj* o) {
    return o->clz;
}

INLINE jobjectID obj_get_class_id (obj* o) {
    return cls_get_class_id (o->clz);
}

INLINE jint obj_get_size (obj* o) {
    return o->size;
}

INLINE void obj_set_arena_id (obj* o, jint arena_id) {
    o->arena_id = arena_id;
}

INLINE int obj_get_reset_level (obj* o) {
    return o->reset_level;
}

INLINE int obj_get_gc_level (obj* o) {
    return o->gc_level;
}


/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
