#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>

#include <jmp.h>
#include <cls.h>
#include <method.h>
#include <comparators.h>
#ifdef HAVE_WIN32COMPAT_H
 #include <win32compat.h>
#endif

#include <ui_file.h>
#include <ui_gtk.h>	/* set_status() */

/** id of last dump file... */
static int dump_id = -1;

/** Are we dumping on a timer basis? */
static long  dumptimer = 0;   /* The countdown value (10)... */
static long  dumptime = 0;    /* Current value (1, 2, 3, 4,....) */

/* Called every second */
void dumptimer_tick(void) {
    if (dumptimer > 0) {
	dumptime++;
	if (dumptime == dumptimer) {
	    run_data_dump ();
	    dumptime = 0;
	}
    }
}

void dump_clean (void) {
//    if (threadslist) {
//	free (threadslist);
//        threadslist = NULL;
//    }
}

/** Return the id of the dump file. */
int dump_data (char* dumpdir, hashtab* classes, hashtab* methods, hashtab* threads) {
    FILE* f;
    char filename[256];
    char status[128];
    snprintf (filename, sizeof(filename), "%s/jmp_dump-%d.txt", 
	      (dumpdir == NULL ? "." : dumpdir), ++dump_id);    
    snprintf (status, sizeof(status), _("dumped to: %s"), filename);
    set_status (status);
    f = fopen (filename, "w");
    if (f == NULL)
	return -1;

    dump_threads (threads, f);
    fprintf (f, "\n\n\n");
    dump_classes (classes, f);
    fprintf (f, "\n\n\n");
    dump_methods (methods, f);

    fflush (f);
    fclose (f);
    return dump_id;
}

/** Set the dump timer... */
void set_dump_timer (int dt) {
    dumptimer = dt;
}

/** Get the current dump timer. */
int get_dump_timer () {
    return dumptimer;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
