import base
import pygtk
pygtk.require("2.0")
import gtk
import gnome.ui
import random
import os.path
import mx.DateTime

from gtk_models import MemosModel


class pane(base.pane):
    def __init__(self, glade_path=os.path.join("@@python_module_prefix@@","gui"),model=None):
        
        gladefile = os.path.join(glade_path, "memos.glade")
        wTree=gtk.glade.XML(gladefile,"vpanedMemos")

        self.name = "Memos"
        if model is None:
            self.model = MemosModel()
        else:
            self.model = model
        self.view = wTree.get_widget("TreeView")
        self.main_vpaned = wTree.get_widget("vpanedMemos")        
        self.recordCategoryOpenMenu = wTree.get_widget("CategoryOptionMenu")
        self.categoryFilterVBox = wTree.get_widget("CategoryVBox")
        
        
        # unsupported fields
        wTree.get_widget("PrivateCheckButton").set_sensitive(False)

        base.pane.__init__(self, gladefile, wTree)

        self.deleteButton = wTree.get_widget("memosDeleteButton")        

        # prepare for bringing up UI
        dic = {
            "on_TreeView_button_press_event": (self.on_TreeView_button_press_event,
                                                       self.rightClickColumnMenu),
            "on_FilterButton_clicked": (self.on_FilterButton, "FilterEntry"),
            "on_FilterEntry_keyrelease": (self.on_FilterEntry_keyrelease, self.model),
            
            "on_memosRevertButton_clicked": (self.on_RevertButton, self.model),
            "on_memosNewButton_clicked": (self.on_NewButton, self.model,
                                             self.view, "Description"),
            "on_memosDeleteButton_clicked": (self.on_DeleteButton),
            }
        
        self.wTree.signal_autoconnect(dic)
