import pygtk
pygtk.require("2.0")
import gtk
import gobject
import pango
import types
import mx.DateTime

# http://www.sicem.biz/personal/lgs/docs/gobject-python/gobject-tutorial.html

mxDateTimeType = type(mx.DateTime.now())

class PyObjectRenderer(gtk.GenericCellRenderer):
                                                                                
    __gproperties__ = {
        'value' : (gobject.TYPE_PYOBJECT,          # type
                  'Value',                         # nick name
                  'Value',                         # description
                  gobject.PARAM_READWRITE),        # flags
        'names' : (gobject.TYPE_PYOBJECT,          # type
                  'Names',                         # nick name
                  'Friendly string names for the values', # description
                  gobject.PARAM_READWRITE)         # flags        
        }
    
    property_names = __gproperties__.keys()
                                                                                
    def __init__(self):
        self.__gobject_init__()
                                                                                
        self.xpad = 3
        self.ypad = 3
                                                                                
        self.xalign = 0.0
        self.yalign = 0.5
                                                                                
    def __getattr__(self, name):
        try:
            return self.get_property(name)
        except TypeError:
            raise AttributeError
                                                                                
    def __setattr__(self, name, value):
        try:
            self.set_property(name, value)
        except TypeError:
            self.__dict__[name] = value
                                                                                
    def do_get_property(self, property):
        if property.name not in self.property_names:
            raise TypeError('No property named %s' % (property.name,))
        return self.__dict__[property.name]
                                                                                
    def do_set_property(self, property, value):
        if property.name not in self.property_names:
            raise TypeError('No property named %s' % (property.name,))
        self.__dict__[property.name] = value

    def value_to_layout(self, layout):
        val = self.get_property('value')
        if not val:
            return layout
        elif isinstance(val,mxDateTimeType):
            layout.set_markup(str(val.date))
            #layout.set_width(-1)  # turn off wrapping
        elif val == None:
            layout.set_markup('')
        else:
            layout.set_markup('<span weight="bold">%s</span>' % val)
        return layout
                                                                                
    def on_render(self, window, widget, background_area,
                  cell_area, expose_area, flags):
        x_offset, y_offset, width, height = self.on_get_size(widget, cell_area)
        width -= self.xpad * 2
        height -= self.ypad * 2
                                                                                
        layout = self.value_to_layout(pango.Layout(widget.get_pango_context()))
        
        widget.style.paint_layout(window, gtk.STATE_NORMAL, True,
                                  cell_area, widget, 'dummy',
                                  cell_area.x + x_offset,
                                  cell_area.y + y_offset,
                                  layout)
                                                                                
                                                                                 
    def on_get_size(self, widget, cell_area):
        layout = self.value_to_layout(pango.Layout(widget.get_pango_context()))
        width, height = layout.get_pixel_size()
                                                                               
        if cell_area:
            y_offset = self.yalign * (cell_area.height - height)
            y_offset = max(y_offset, 0)
        else:
            y_offset = self.ypad
                                                                                
        x_offset = self.xpad
        y_offset = self.ypad
        return x_offset, y_offset, width, height
                                                                                

class ListItemRenderer(PyObjectRenderer):
                                                                                
    __gproperties__ = {
        'index' : (gobject.TYPE_UINT,              # type
                  'index',                         # nick name
                  'Index into Names',              # description
                   0,255,0,                        # min,max,default
                  gobject.PARAM_READWRITE),        # flags
        'names' : (gobject.TYPE_PYOBJECT,          # type
                  'Names',                         # nick name
                  'Friendly string names for the values', # description
                  gobject.PARAM_READWRITE)         # flags        
        }

    property_names = __gproperties__.keys()
    
    def value_to_layout(self, layout):
        val = self.get_property('index')
        lst = self.get_property('names')
        #print val, lst
        if lst == None:
            layout.set_markup("None")
        else:
            layout.set_markup(str(lst[val]))
        return layout
