
/*
 * mixer.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MIXER_C
#define MIXER_C

#include <time.h>
#include <string.h>
#include <stdlib.h>

#include "dialogs/typedefs.h"
#include "dialogs/windows.h"
#include "dialogs/dialogs.h"

#include "mixer/mixer.h"

#include "typedefs.h"
#include "mixer.h"

typedef struct	/* Channel type */
{
   char label[20];
   int type;
} chan_t;

MixerDialog::MixerDialog ()
{
   reset = FALSE;
   saved_volume = -1;
}

void MixerDialog::Reset ()
{
   reset = TRUE;
}

void MixerDialog::SetSettings (int vol,int bass,int treble,int synth,
							   int pcm,int ogain,int balance)
{
   vol_volume = vol;
   vol_bass = bass;
   vol_treble = treble;
   vol_synth = synth;
   vol_pcm = pcm;
   vol_ogain = ogain;
   vol_balance = balance;
}

void MixerDialog::GetSettings (int &vol,int &bass,int &treble,int &synth,
							   int &pcm,int &ogain,int &balance)
{
   vol = vol_volume;
   bass = vol_bass;
   treble = vol_treble;
   synth = vol_synth;
   pcm = vol_pcm;
   ogain = vol_ogain;
   balance = vol_balance;
}

void MixerDialog::drawbuttons (PANEL *curpan,int x,int y)
{
   WINDOW *curwin = panel_window (curpan);
   setcolor (curwin,GREEN,BLACK,A_NORMAL);
   for (int i = 0; i < 16; i += 2) mvwaddch (curwin,y,x + i,sc_dot);
   setcolor (curwin,YELLOW,BLACK,A_NORMAL);
   for (int i = 16; i < 32; i += 2) mvwaddch (curwin,y,x + i,sc_dot);
   setcolor (curwin,RED,BLACK,A_NORMAL);
   for (int i = 32; i < 45; i += 2) mvwaddch (curwin,y,x + i,sc_dot);
   setcolor (curwin,WHITE,BLACK,A_NORMAL);
}

void MixerDialog::drawbalance (PANEL *curpan,int x,int y)
{
   WINDOW *curwin = panel_window (curpan);
   setcolor (curwin,RED,BLACK,A_NORMAL);
   for (int i = 0; i < 12; i += 2) mvwaddch (curwin,y,x + i,sc_dot);
   setcolor (curwin,YELLOW,BLACK,A_NORMAL);
   for (int i = 12; i < 36; i += 2) mvwaddch (curwin,y,x + i,sc_dot);
   setcolor (curwin,RED,BLACK,A_NORMAL);
   for (int i = 36; i < 45; i += 2) mvwaddch (curwin,y,x + i,sc_dot);
   setcolor (curwin,GREEN,BLACK,A_NORMAL);
   mvwaddch (curwin,y,37,sc_dot);
   mvwaddch (curwin,y,39,sc_dot);
   mvwaddch (curwin,y,41,sc_dot);
   setcolor (curwin,WHITE,BLACK,A_NORMAL);
}

int MixerDialog::calcvolume (int volume)
{
   int tmp,left,right;
   tmp = (int) ((float) volume / 0.44);
   left = right = tmp;
   tmp = (int) ((float) vol_balance / 0.44);
   if (tmp < 0) right += tmp; else left -= tmp;
   if (right > 100) right = 100;
   if (right < 0) right = 0;
   if (left > 100) left = 100;
   if (left < 0) left = 0;
   return (left + (right << 8));
}

void MixerDialog::ShowMixer ()
{
   Mixer Mix;
   if (!Mix.Open ())
	 {
		Info ((COLS - 22) >> 1,LINES >> 1,"No mixer available",A_BOLD,WHITE,RED);
		return;
	 }
   if (!Mix.HasChannel (MIXER_VOLUME))
	 {
		Info ((COLS - 48) >> 1,LINES >> 1,"Your soundcard doesn't have a volume channel",
			  A_BOLD,WHITE,RED);
		Mix.Close ();
		return;
	 }
   bool bass_present,treble_present,synth_present,pcm_present,ogain_present,balance_present;
   int prv_volume,prv_bass,prv_treble,prv_synth,prv_pcm,prv_ogain,prv_balance;
   /* To keep g++ happy... */
   prv_bass = prv_treble = prv_synth = prv_pcm = prv_ogain = prv_balance = 0;
   int tmp = Mix.GetVolume (MIXER_VOLUME);
   int num_channels = 1;
   chan_t channel[6];
   bass_present = Mix.HasChannel (MIXER_BASS);
   treble_present = Mix.HasChannel (MIXER_TREBLE);
   synth_present = Mix.HasChannel (MIXER_SYNTH);
   pcm_present = Mix.HasChannel (MIXER_PCM);
   ogain_present = Mix.HasChannel (MIXER_OGAIN);
   balance_present = Mix.IsStereo (MIXER_VOLUME);
   vol_volume = saved_volume = prv_volume = (int) ((tmp & 0xFF) * 0.44);
   strcpy (channel[0].label,"Volume");
   channel[0].type = MIXER_VOLUME;
   if (bass_present)
	 {
		vol_bass = prv_bass = (int) ((Mix.GetVolume (MIXER_BASS) & 0xFF) * 0.44);
		strcpy (channel[num_channels].label,"Bass");
		channel[num_channels].type = MIXER_BASS;
		num_channels++;
	 }
   if (treble_present)
	 {
		vol_treble = prv_treble = (int) ((Mix.GetVolume (MIXER_TREBLE) & 0xFF) * 0.44);
		strcpy (channel[num_channels].label,"Treble");
		channel[num_channels].type = MIXER_TREBLE;
		num_channels++;
	 }
   if (synth_present)
	 {
		vol_synth = prv_synth = (int) ((Mix.GetVolume (MIXER_SYNTH) & 0xFF) * 0.44);
		strcpy (channel[num_channels].label,"Synth");
		channel[num_channels].type = MIXER_SYNTH;
		num_channels++;
	 }
   if (pcm_present)
	 {
		vol_pcm = prv_pcm = (int) ((Mix.GetVolume (MIXER_PCM) & 0xFF) * 0.44);
		strcpy (channel[num_channels].label,"Pcm");
		channel[num_channels].type = MIXER_PCM;
		num_channels++;
	 }
   if (ogain_present)
	 {
		vol_ogain = prv_ogain = (int) ((Mix.GetVolume (MIXER_OGAIN) & 0xFF) * 0.44);
		strcpy (channel[num_channels].label,"OGain");
		channel[num_channels].type = MIXER_OGAIN;
		num_channels++;
	 }
   if (balance_present)
	 vol_balance = prv_balance = (int) (((tmp & 0xFF) - (tmp & 0x00FF)) * 0.44);
   PANEL *curpan;
   WINDOW *curwin;
   bool finished = FALSE;
   int option = 0;
   chtype ch;
   Add (67,17,(COLS - 67) >> 1,(LINES - 16) >> 1,"Mixer",A_NORMAL,WHITE,BLACK);
   curpan = GetPanel ();
   curwin = GetWindow ();
   for (int i = 0; i < num_channels; i++)
	 {
		drawbuttons (curpan,17,2 * (i + 1));
		mvwaddstr (curwin,2 * (i + 1) + 1,7,channel[i].label);
		horzline (curpan,17,61,2 * (i + 1) + 1,FALSE,TRUE,SIDE_NORMAL,SIDE_NORMAL);
	 }
   drawbuttons (curpan,17,2 * (num_channels + 1));
   if (balance_present)
	 {
		mvwaddstr (curwin,2 * (num_channels + 1) + 1,7,"Balance");
		horzline (curpan,17,61,2 * (num_channels + 1) + 1,FALSE,TRUE,SIDE_NORMAL,SIDE_NORMAL);
		drawbalance (curpan,17,2 * (num_channels + 2));
	 }
   keypad (curwin,TRUE);
   do
	 {
		setcolor (curwin,WHITE,BLACK,A_NORMAL);
		for (int i = 0; i < num_channels; i++)
		  {
			 switch (channel[i].type)
			   {
				case MIXER_VOLUME:
				  mvwaddch (curwin,2 * (i + 1) + 1,prv_volume + 17,lcd_horz);
				  mvwaddch (curwin,2 * (i + 1) + 1,vol_volume + 17,sc_button);
				  prv_volume = vol_volume;
				  break;
				case MIXER_BASS:
				  mvwaddch (curwin,2 * (i + 1) + 1,prv_bass + 17,lcd_horz);
				  mvwaddch (curwin,2 * (i + 1) + 1,vol_bass + 17,sc_button);
				  prv_bass = vol_bass;
				  break;
				case MIXER_TREBLE:
				  mvwaddch (curwin,2 * (i + 1) + 1,prv_treble + 17,lcd_horz);
				  mvwaddch (curwin,2 * (i + 1) + 1,vol_treble + 17,sc_button);
				  prv_treble = vol_treble;
				  break;
				case MIXER_SYNTH:
				  mvwaddch (curwin,2 * (i + 1) + 1,prv_synth + 17,lcd_horz);
				  mvwaddch (curwin,2 * (i + 1) + 1,vol_synth + 17,sc_button);
				  prv_synth = vol_synth;
				  break;
				case MIXER_PCM:
				  mvwaddch (curwin,2 * (i + 1) + 1,prv_pcm + 17,lcd_horz);
				  mvwaddch (curwin,2 * (i + 1) + 1,vol_pcm + 17,sc_button);
				  prv_pcm = vol_pcm;
				  break;
				case MIXER_OGAIN:
				  mvwaddch (curwin,2 * (i + 1) + 1,prv_ogain + 17,lcd_horz);
				  mvwaddch (curwin,2 * (i + 1) + 1,vol_ogain + 17,sc_button);
				  prv_ogain = vol_ogain;
			   }
		  }
		if (balance_present)
		  {
			 mvwaddch (curwin,2 * (num_channels + 1) + 1,prv_balance + 39,lcd_horz);
			 mvwaddch (curwin,2 * (num_channels + 1) + 1,vol_balance + 39,sc_button);
			 prv_balance = vol_balance;
		  }
		if (option == num_channels)
		  tmp = vol_balance + 22;
		else
		  switch (channel[option].type)
			{
			 case MIXER_VOLUME: tmp = vol_volume; break;
			 case MIXER_BASS: tmp = vol_bass; break;
			 case MIXER_TREBLE: tmp = vol_treble; break;
			 case MIXER_SYNTH: tmp = vol_synth; break;
			 case MIXER_PCM: tmp = vol_pcm; break;
			 case MIXER_OGAIN: tmp = vol_ogain;
		    }
		setcolor (curwin,BLUE,BLACK,A_BOLD);
		mvwaddch (curwin,3 + option * 2,tmp + 17,sc_button);
		setcolor (curwin,WHITE,BLACK,A_NORMAL);
		Update ();
		ch = wgetch (curwin);
		if (ch == KEY_UP)
		  {
			 if (option > 0) option--; else option = num_channels;
		  }
		else if (ch == KEY_DOWN)
		  {
			 if (option < num_channels) option++; else option = 0;
		  }
		else if (ch == KEY_LEFT)
		  {
			 if (option == num_channels)
			   {
				  if (vol_balance > -22)
					{
					   vol_balance--;
					   saved_volume = vol_volume;
					   Mix.SetVolume (MIXER_VOLUME,calcvolume (vol_volume));
					   Mix.SetVolume (MIXER_BASS,calcvolume (vol_bass));
					   Mix.SetVolume (MIXER_TREBLE,calcvolume (vol_treble));
					   Mix.SetVolume (MIXER_SYNTH,calcvolume (vol_synth));
					   Mix.SetVolume (MIXER_PCM,calcvolume (vol_pcm));
					}
				  else beep ();
			   }
			 else
			   {
				  switch (channel[option].type)
					{
					 case MIXER_VOLUME:
					   if (vol_volume)
						 {
							vol_volume--;
							saved_volume = vol_volume;
							Mix.SetVolume (MIXER_VOLUME,calcvolume (vol_volume));
						 }
					   else beep ();
					   break;
					 case MIXER_BASS:
					   if (vol_bass)
						 {
							vol_bass--;
							Mix.SetVolume (MIXER_BASS,calcvolume (vol_bass));
						 }
					   else beep ();
					   break;
					 case MIXER_TREBLE:
					   if (vol_treble)
						 {
							vol_treble--;
							Mix.SetVolume (MIXER_TREBLE,calcvolume (vol_treble));
						 }
					   else beep ();
					   break;
					 case MIXER_SYNTH:
					   if (vol_synth)
						 {
							vol_synth--;
							Mix.SetVolume (MIXER_SYNTH,calcvolume (vol_synth));
						 }
					   else beep ();
					   break;
					 case MIXER_PCM:
					   if (vol_pcm)
						 {
							vol_pcm--;
							Mix.SetVolume (MIXER_PCM,calcvolume (vol_pcm));
						 }
					   else beep ();
					   break;
					 case MIXER_OGAIN:
					   if (vol_ogain)
						 {
							vol_ogain--;
							Mix.SetVolume (MIXER_OGAIN,calcvolume (vol_ogain));
						 }
					   else beep ();
					}
			   }
		  }
		else if (ch == KEY_RIGHT)
		  {
			 if (option == num_channels)
			   {
				  if (vol_balance < 22)
					{
					   vol_balance++;
					   saved_volume = vol_volume;
					   Mix.SetVolume (MIXER_VOLUME,calcvolume (vol_volume));
					   Mix.SetVolume (MIXER_BASS,calcvolume (vol_bass));
					   Mix.SetVolume (MIXER_TREBLE,calcvolume (vol_treble));
					   Mix.SetVolume (MIXER_SYNTH,calcvolume (vol_synth));
					   Mix.SetVolume (MIXER_PCM,calcvolume (vol_pcm));
					}
				  else beep ();
			   }
			 else
			   {
				  switch (channel[option].type)
					{
					 case MIXER_VOLUME:
					   if (vol_volume < 44)
						 {
							vol_volume++;
							saved_volume = vol_volume;
							Mix.SetVolume (MIXER_VOLUME,calcvolume (vol_volume));
						 }
					   else beep ();
					   break;
					 case MIXER_BASS:
					   if (vol_bass < 44)
						 {
							vol_bass++;
							Mix.SetVolume (MIXER_BASS,calcvolume (vol_bass));
						 }
					   else beep ();
					   break;
					 case MIXER_TREBLE:
					   if (vol_treble < 44)
						 {
							vol_treble++;
							Mix.SetVolume (MIXER_TREBLE,calcvolume (vol_treble));
						 }
					   else beep ();
					   break;
					 case MIXER_SYNTH:
					   if (vol_synth < 44)
						 {
							vol_synth++;
							Mix.SetVolume (MIXER_SYNTH,calcvolume (vol_synth));
						 }
					   else beep ();
					   break;
					 case MIXER_PCM:
					   if (vol_pcm < 44)
						 {
							vol_pcm++;
							Mix.SetVolume (MIXER_PCM,calcvolume (vol_pcm));
						 }
					   else beep ();
					   break;
					 case MIXER_OGAIN:
					   if (vol_ogain < 44)
						 {
							vol_ogain++;
							Mix.SetVolume (MIXER_OGAIN,calcvolume (vol_ogain));
						 }
					   else beep ();
					}
			   }
		  }
		else if (IsHotkey (ch))
		  {
			 execfunc (ch);
			 if (reset)
			   {
				  saved_volume = vol_volume;
				  Mix.SetVolume (MIXER_VOLUME,calcvolume (vol_volume));
				  if (bass_present) Mix.SetVolume (MIXER_BASS,calcvolume (vol_bass));
				  if (treble_present) Mix.SetVolume (MIXER_TREBLE,calcvolume (vol_treble));
				  if (synth_present) Mix.SetVolume (MIXER_SYNTH,calcvolume (vol_synth));
				  if (pcm_present) Mix.SetVolume (MIXER_PCM,calcvolume (vol_pcm));
				  reset = FALSE;
			   }
			 finished = abortflag;
		  }
		else if (ch == XCTRL ('l'))
		  {
			 Refresh ();
		  }
		else beep ();
		flushinp ();
	 }
   while (!finished);
   Mix.Close ();
   keypad (curwin,FALSE);
   Remove ();
   Update ();
}

void MixerDialog::FadeDown ()
{
   Mixer Mix;
   unsigned int stepsleft,usec;
   struct timespec tval;
   if (!Mix.Open ())
	 {
		Info ((COLS - 22) >> 1,LINES >> 1,"No mixer available",A_BOLD,WHITE,RED);
		return;
	 }
   if (!Mix.HasChannel (MIXER_VOLUME))
	 {
		Info ((COLS - 48) >> 1,LINES >> 1,"Your soundcard doesn't have a volume channel",
			  A_BOLD,WHITE,RED);
		Mix.Close ();
		return;
	 }
   if (saved_volume == -1)
	 {
		int tmp = Mix.GetVolume (MIXER_VOLUME);
		vol_volume = saved_volume = (int) ((tmp & 0xFF) * 0.44);
		vol_balance = (int) (((tmp & 0xFF) - (tmp & 0x00FF)) * 0.44);
	 }
   if (saved_volume != 0)
	 {
		stepsleft = saved_volume;
		usec = (fadingtime * 1000) / saved_volume;
		tval.tv_sec = usec / 1000000;
		tval.tv_nsec = usec * 1000;
		while (stepsleft--)
		  {
			 Mix.SetVolume (MIXER_VOLUME,calcvolume (stepsleft));
			 nanosleep (&tval,NULL);
		  }
	 }
   Mix.Close ();
}

void MixerDialog::FadeUp ()
{
   Mixer Mix;
   unsigned int stepsleft,usec;
   struct timespec tval;
   if (!Mix.Open ())
	 {
		Info ((COLS - 22) >> 1,LINES >> 1,"No mixer available",A_BOLD,WHITE,RED);
		return;
	 }
   if (!Mix.HasChannel (MIXER_VOLUME))
	 {
		Info ((COLS - 48) >> 1,LINES >> 1,"Your soundcard doesn't have a volume channel",
			  A_BOLD,WHITE,RED);
		Mix.Close ();
		return;
	 }
   if (saved_volume == -1)
	 {
		int tmp = Mix.GetVolume (MIXER_VOLUME);
		vol_volume = saved_volume = (int) ((tmp & 0xFF) * 0.44);
		vol_balance = (int) (((tmp & 0xFF) - (tmp & 0x00FF)) * 0.44);
	 }
   Mix.SetVolume (MIXER_VOLUME,0);
   if (saved_volume != 0)
	 {
		stepsleft = saved_volume;
		usec = (fadingtime * 1000) / saved_volume;
		tval.tv_sec = usec / 1000000;
		tval.tv_nsec = usec * 1000;
		while (stepsleft--)
		  {
			 Mix.SetVolume (MIXER_VOLUME,calcvolume (saved_volume - stepsleft));
			 nanosleep (&tval,NULL);
		  }
	 }
   Mix.Close ();
}

#endif

