// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include "bitmap_functions.h"
#include "simple_bitmap_modifier.h"

#include <k3dsdk/i18n.h>
#include <k3dsdk/measurement.h>
#include <k3dsdk/module.h>

namespace libk3dbitmap
{

class bitmap_size :
	public simple_bitmap_modifier
{
	typedef simple_bitmap_modifier base;

public:
	bitmap_size(k3d::idocument& Document) :
		base(Document),
		m_width(init_owner(*this) + init_name("pixel_width") + init_label(_("Output pixel width")) + init_description(_("Output pixel width")) + init_value(320) + init_constraint(constraint::minimum(1L)) + init_step_increment(1) + init_units(typeid(k3d::measurement::scalar))),
		m_height(init_owner(*this) + init_name("pixel_height") + init_label(_("Output pixel height")) + init_description(_("Output pixel height")) + init_value(240) + init_constraint(constraint::minimum(1L)) + init_step_increment(1) + init_units(typeid(k3d::measurement::scalar)))
	{
		m_width.changed_signal().connect(make_reset_bitmap_slot());
		m_height.changed_signal().connect(make_reset_bitmap_slot());
	}

	void on_create_bitmap(const k3d::bitmap& Input, k3d::bitmap& Output)
	{
		Output.reset(m_width.value(), m_height.value());
		std::fill(Output.begin(), Output.end(), k3d::pixel());
		resize(Input, Output);
	}

	void on_update_bitmap(const k3d::bitmap& Input, k3d::bitmap& Output)
	{
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<bitmap_size>,
			k3d::interface_list<k3d::ibitmap_source,
			k3d::interface_list<k3d::ibitmap_sink> > > factory(
				k3d::uuid(0xc8a70bc7, 0xeef04dc1, 0x8b8a2001, 0x6ab63b4a),
				"BitmapSize",
				_("Set bitmap size by cropping or padding"),
				"Bitmap",
				k3d::iplugin_factory::STABLE);

		return factory;
	}

private:
	k3d_data(long, immutable_name, change_signal, with_undo, local_storage, with_constraint, measurement_property, with_serialization) m_width;
	k3d_data(long, immutable_name, change_signal, with_undo, local_storage, with_constraint, measurement_property, with_serialization) m_height;
};

/////////////////////////////////////////////////////////////////////////////
// bitmap_size_factory

k3d::iplugin_factory& bitmap_size_factory()
{
	return bitmap_size::get_factory();
}

} // namespace libk3dbitmap


