#ifndef CENZOR_H
#define CENZOR_H

#include <qobject.h>
#include "usergroup.h"
#include <qmap.h>

#include "configuration_aware_object.h"
#include "main_configuration_window.h"

class Chat;
class PowerKadu;
class Protocol;

class Cenzor : public ConfigurationUiHandler, ConfigurationAwareObject
{
	Q_OBJECT;
    
	private:
		QStringList swearList;
		QStringList exclusionList;

		QListBox *swearListBox;
		QListBox *exclusionListBox;
		QLineEdit *swear;
		QLineEdit *exclusion;

		/*!
			\fn int check(QCString& msg)
			\param msg the message to receive
		*/
		int check(QCString& msg);
		
		/*!
			\fn void admonition(UserListElements senders)
			\param senders list of adminition receivers
		*/
		void admonition(UserListElements senders);
		
		void words_read();
		void words_save();
		int checkOkWords(QString txt);
		void update_swearList();
		void update_exclusionList();
		void addDefaultConfiguration();

	public:
		//! Default constructor
		/*! 
			\param pk pointer to PowerKadu object
		*/
		Cenzor();

		//! Default destructor
		~Cenzor();

		virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);


	private slots:
		void swearwordSelected(int);
		void addSwearword();
		void changeSwearword();
		void deleteSwearword();

		void exlusionSelected(int);
		void addExclusion();
		void changeExclusion();
		void deleteExclusion();

	public slots:
		void messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop);

	protected:
		virtual void configurationUpdated();
};

extern Cenzor *cenzor;

#endif
