/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "forecast_container.h"
#include "weather_global.h"

#include "config_file.h"
#include "debug.h"

/**
	ForecastContener
**/

const Forecast* ForecastContainer::getForecast( const QString& configFile, const QString& location )
{
	kdebugf();
	
	for(QValueListIterator<Forecast> it = list_.begin(); it != list_.end(); it++)
	{
		if( (*it).LocationID == location && (*it).config == configFile)
		{
			if( (*it).loadTime.elapsed() > WeatherGlobal::KEEP_FORECAST*60*60*1000 )
			{
				list_.remove(it);
				return 0;
			}
			else
			{
				return &(*it);
			}
		}
	}
	
	kdebugf2();
	return 0;
}

void ForecastContainer::deleteObsolete()
{
	kdebugf();
	
	for(QValueListIterator<Forecast> it = list_.begin(); it != list_.end(); )
	{
		if( (*it).loadTime.elapsed() > WeatherGlobal::KEEP_FORECAST*60*60*1000)
			it = list_.remove(it);
		else
			it++;
	}
	
	kdebugf2();
}

void ForecastContainer::add( const Forecast& forecast )
{
	kdebugf();
	
	if( WeatherGlobal::KEEP_FORECAST > 0)
	{
		bool replace = false;
		for(QValueListIterator<Forecast> it = list_.begin(); it != list_.end(); it++)
		{
			if( (*it).LocationID == forecast.LocationID && (*it).config == forecast.config)
			{
				(*it) = forecast;
				replace = true;
				break;
			}
		}
		
		if(!replace)
			list_.push_front(forecast);
	}
	
	kdebugf2();
}

