/***************************************************************************
 *   Copyright (C) 2005 by Michael Goettsche                               *
 *   michael.goettsche@kdemail.net                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kfiledialog.h>

#include <qcombobox.h>
#include <qpushbutton.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qfileinfo.h>

#include "leveleditor.h"


LevelEditor::LevelEditor(QWidget* parent)
    :LevelEditor_base(parent)
{
    lastDir = QString::null;
    
    difficultyComboBox->insertItem(i18n("Easy"));
    difficultyComboBox->insertItem(i18n("Average"));
    difficultyComboBox->insertItem(i18n("Hard"));
    difficultyComboBox->insertItem(i18n("Expert"));

    typeComboBox->insertItem(i18n("Addition"));
    typeComboBox->insertItem(i18n("Subtraction"));
    typeComboBox->insertItem(i18n("Multiplication"));
    typeComboBox->insertItem(i18n("Division"));
    typeComboBox->insertItem(i18n("Mixed"));


    connect(addQuestionButton, SIGNAL(clicked()), this, SLOT(addQuestion()));
    connect(deleteQuestionButton, SIGNAL(clicked()), this, SLOT(deleteQuestion()));

    connect(newLevelButton, SIGNAL(clicked()), this, SLOT(newLevel()));
    connect(openLevelButton, SIGNAL(clicked()), this, SLOT(openLevel()));
    connect(saveLevelButton, SIGNAL(clicked()), this, SLOT(saveLevel()));
    connect(closeButton, SIGNAL(clicked()), this, SLOT(accept()));
}


void LevelEditor::addQuestion()
{
    QListViewItem* item = new QListViewItem(questionListView);
    item->setText(0, i18n("Double-Click"));
    item->setText(1, i18n("to edit"));
    item->setRenameEnabled(0, true);
    item->setRenameEnabled(1, true);
}

void LevelEditor::deleteQuestion()
{
    delete questionListView->currentItem();
}

void LevelEditor::newLevel()
{
    reset();
}

void LevelEditor::openLevel()
{
    QString fileToOpen = KFileDialog::getOpenFileName(QString::null, "*.kalcul|Kalcul Levels (*.kalcul)");
    QFileInfo fileInfo(fileToOpen);
    lastDir = fileInfo.dirPath(true);
        
    QFile file(fileToOpen);
    if (file.open(IO_ReadOnly)) {
        QTextStream stream(&file);
        
        int i = 0;
        QString line;
        QString questions;
        
        while (!stream.atEnd()) {
            line = stream.readLine();
                
            switch (i) {
            case 0:
                nameLineEdit->setText(line.mid(line.find("=") + 2));
                break;
            case 1:
                typeComboBox->setCurrentText(line.mid(line.find("=") + 2));
                break;
            case 2:
                //level.numOfQuestions = line.mid(line.find("=") + 2);
                break;
            case 3:
                difficultyComboBox->setCurrentText(line.mid(line.find("=") + 2));
                break;
            default:
               questions.append(line + "\n"); 
            }
            i++;
        }

        QStringList questionsList = QStringList::split("\n", questions);
        int tmpPosition;
        
        for (QStringList::Iterator it = questionsList.begin(); it != questionsList.end();
             ++it) {
            QListViewItem* item = new QListViewItem(questionListView);
            tmpPosition = (*it).find("=");
            item->setText(0, (*it).left(tmpPosition));
            item->setText(1, (*it).mid(tmpPosition + 2));
            item->setRenameEnabled(0, true);
            item->setRenameEnabled(1, true);
        }
    }
}
    
void LevelEditor::saveLevel()
{
    QString fileToSave = KFileDialog::getSaveFileName(lastDir, "*.kalcul|Kalcul Levels (*.kalcul)");

    QFile file(fileToSave);
    if (file.open(IO_WriteOnly)) {
        QTextStream stream(&file);

        stream << "Name = " << nameLineEdit->text() << "\n";
        stream << "Type = " << typeComboBox->currentText() << "\n";
        stream << "Questions = " << questionListView->childCount() << "\n";
        stream << "Difficulty = " << difficultyComboBox->currentText() << "\n";

        QListViewItemIterator it(questionListView);
        while (it.current()) {
            stream << it.current()->text(0) << " = " << it.current()->text(1) << "\n";
            ++it;
        }
    }
}

void LevelEditor::accept()
{
    reset();
    QDialog::accept();
}

void LevelEditor::reset()
{
    questionListView->clear();
    nameLineEdit->setText(QString::null);
    difficultyComboBox->setCurrentItem(0);
    typeComboBox->setCurrentItem(0);
}

#include "leveleditor.moc"

