/*
    emulatorconfigwidget.h - Emulator configuration widget

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef EMULATORCONFIGWIDGET_H
#define EMULATORCONFIGWIDGET_H

#include <qgroupbox.h>

/**
This is a small groupbox specialized to configure a emulator path and arguments. In the groupbox title, it display the name of the system(obtained from constructor).

@author Michaël Larouche
*/
class EmulatorConfigWidget : public QGroupBox
{
	Q_OBJECT
public:
	EmulatorConfigWidget(const QString &systemName, QWidget *parent, const char *name = 0);
	~EmulatorConfigWidget();

signals:
	void settingsChanged();

public slots:
	void loadSettings();
	void saveSettings();

private:
	class Private;
	Private *d;

};

#endif
