/******************************************************************************
	romlistviewitem.cpp - Specialized list entry containing ROM path
	
	Copyright (c) 2006 by Brian S. Stephan
	bssteph@incorporeal.org
	
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
	
 *****************************************************************************/

#include <collectionaccess.h>

#include "romlistviewitem.h"

class RomListViewItem::Private
{
public:
	Private()
	{}

	QString romUrl;
};

RomListViewItem::RomListViewItem(KListView *parent, const Kamefu::RomMetaInformation &romMetaInfo)
 : KListViewItem(parent), d(new Private)
{
	d->romUrl = romMetaInfo.url();
	
	// use writeColumns since we already have the info
	writeColumns(romMetaInfo);
}

RomListViewItem::~RomListViewItem()
{
	delete d;
}

void RomListViewItem::writeColumns(const Kamefu::RomMetaInformation &romMetaInfo)
{
	// TODO: Make the list (and thus the display of each row) configurable
	setText(0, romMetaInfo.romName());
	setText(1, romMetaInfo.editor());
	setText(2, romMetaInfo.country());
	setText(3, romMetaInfo.system());
}

void RomListViewItem::refreshInfo()
{
	Kamefu::RomMetaInformation romMetaInfo =
		Kamefu::CollectionAccess::self()->getRomMetadataFromRomUrl(d->romUrl);
	
	writeColumns(romMetaInfo);
}

QString RomListViewItem::romUrl()
{
	return d->romUrl;
}
