/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SelfExtractor
extends JFrame {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextField2;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel contentPane;
    private File extractdirectory;
    private ExtractZip extractprocess;
    private ResourceBundle i18nmessages;

    public SelfExtractor(ResourceBundle resourceBundle) {
        this.setDefaultCloseOperation(3);
        this.i18nmessages = resourceBundle;
        this.initializeComponent();
        this.setVisible(true);
    }

    public static ImageIcon getImageIcon(String string) {
        return new ImageIcon(ClassLoader.getSystemResource(string));
    }

    private void initializeComponent() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.contentPane = (JPanel)this.getContentPane();
        this.jLabel1.setText(this.i18nmessages.getString("KArchiver_Autoextract_module"));
        this.jLabel1.setToolTipText("KArchiver (c) Eric Coquelle (2005)\n Visit http://perso.wanadoo.fr/coquelle");
        this.jLabel2.setText(this.i18nmessages.getString("Extract_in"));
        this.jLabel3.setIcon(SelfExtractor.getImageIcon("Pics/karchiveur_wizard_large.png"));
        this.jTextField2.setText(System.getProperty("user.home"));
        this.jButton1.setIcon(SelfExtractor.getImageIcon("Pics/hi48-app-karchiver-out.png"));
        this.jButton1.setText(this.i18nmessages.getString("Extract"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelfExtractor.this.jButton1_actionPerformed(actionEvent);
            }
        });
        this.jButton2.setText(this.i18nmessages.getString("Browse"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelfExtractor.this.jButton2_actionPerformed(actionEvent);
            }
        });
        this.contentPane.setLayout(null);
        this.addComponent(this.contentPane, this.jLabel1, 10, 4, 370, 38);
        this.addComponent(this.contentPane, this.jLabel2, 144, 48, 131, 30);
        this.addComponent(this.contentPane, this.jLabel3, 5, 43, 135, 176);
        this.addComponent(this.contentPane, this.jTextField2, 144, 78, 131, 31);
        this.addComponent(this.contentPane, this.jButton1, 189, 123, 136, 68);
        this.addComponent(this.contentPane, this.jButton2, 288, 78, 83, 34);
        this.setTitle(this.i18nmessages.getString("KArchiver_SelfExtract_archive"));
        this.setLocation(new Point(125, 25));
        this.setSize(new Dimension(390, 256));
        this.setResizable(false);
    }

    private void addComponent(Container container, Component component, int n, int n2, int n3, int n4) {
        component.setBounds(n, n2, n3, n4);
        container.add(component);
    }

    private void jButton1_actionPerformed(ActionEvent actionEvent) {
        this.extractdirectory = new File(this.jTextField2.getText());
        if (!this.extractdirectory.exists()) {
            int n = JOptionPane.showConfirmDialog(this, this.i18nmessages.getString("The_directory") + " " + this.extractdirectory.getAbsolutePath() + " " + this.i18nmessages.getString("doesnt_exist_create_it"), this.i18nmessages.getString("KArchiver_Create_these_directories"), 0);
            if (n == 1) {
                return;
            }
            if (!this.extractdirectory.mkdirs()) {
                JOptionPane.showMessageDialog(this, this.i18nmessages.getString("Cannot_create_this_directory"), this.i18nmessages.getString("KArchiver_problem"), 0);
                return;
            }
        }
        this.extractprocess = new ExtractZip(this.i18nmessages);
        this.extractprocess.extract(this.getJarFileName(), this.extractdirectory, this);
    }

    private void jButton2_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(this.i18nmessages.getString("Select_extraction_directory"));
        if (jFileChooser.showDialog(this, this.i18nmessages.getString("Select")) == 0) {
            this.extractdirectory = jFileChooser.getSelectedFile();
            this.jTextField2.setText(this.extractdirectory.getAbsolutePath());
        }
    }

    private String getJarFileName() {
        String string = this.getClass().getName() + ".class";
        this.getClass().getClassLoader();
        URL uRL = ClassLoader.getSystemResource(string);
        String string2 = uRL.toString();
        return string2.substring("jar:file:".length(), string2.indexOf("!/"));
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("MessagesBundle", locale);
        new SelfExtractor(resourceBundle);
    }
}

