/***************************************************************************
                          caddfiles.cpp  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qfileinfo.h>
#include <qlabel.h>

#include "cfiledialog.h"
#include "cfileinfo.h"
#include "caddfiles.h"


CAddFiles::CAddFiles(QWidget *parent, const char *name) : QDialog(parent,name,true){
  initDialog();
  
  setCaption("KArchiver");
  
  connect(bgChooseActionAddFiles, SIGNAL(clicked(int)), this, SLOT(slotSetFocus(int)));
  connect(bBrowseAdd, SIGNAL(clicked()), this, SLOT(slotBrowseAddToOtherArchive()));
  connect(bBrowseCreate, SIGNAL(clicked()), this, SLOT(slotBrowseCreateArchive()));
  connect(bOk, SIGNAL(clicked()), this, SLOT(slotOk()));
  connect(bCancel, SIGNAL(clicked()), this, SLOT(slotCancel()));
  connect(leAddOther, SIGNAL(textChanged(const QString&)), this, SLOT(slotUpdateAddOther(const QString&)));
  connect(leCreate, SIGNAL(textChanged(const QString&)), this, SLOT(slotUpdateCreate(const QString&)));
  rbAddCurrent->setChecked(true);//Default choice: add dropped files to current archive
}
  
CAddFiles::~CAddFiles(){
}

/** The user will browse and choose the archive
to which the files will be added */
void CAddFiles::slotBrowseAddToOtherArchive(){
	CArchiveChoice archiveName;
	QString name;
	
	name=archiveName.openArchive();
	if(!name.isEmpty())
		leAddOther->setText(name);
}

/** The user will enter a new archive name */
void CAddFiles::slotBrowseCreateArchive(){
  QString filter;
  QString name;
  CFileInfo f;
  QDir d;

  f.setFile(leCreate->text());
  d.setPath(f.dirPath(true));
  if(!d.isReadable())
    d=QDir::home();
  CFileDialog dialog(d.path(), NULL, this,"new_archive_dialog", true );
  dialog.setCaption(i18n("KArchiver - Enter the name of the new archive"));
  if(d.isReadable())
    dialog.setSelection(f.fileName());
  dialog.setOperationMode(KFileDialog::Saving);

  if(dialog.exec())
  {
    name=dialog.selectedFile();
    dialog.fixFileExtension(name);

    if(!name.isEmpty())
      leCreate->setText(name);
  }
}

/** Return 0 if we'll add files to current archive,
1 if we'll add to another,
2 if we'll create a new archive
3 if we'll directly open this archive*/
int CAddFiles::getAddFilesChoice(){
	if(rbAddCurrent->isChecked())
		return 0;
	else if(rbAddOther->isChecked())
		return 1;
	else if(rbCreate->isChecked())
		return 2;
	else if(rbOpenArchive->isChecked())
		return 3;
	return -1;
}

/** return the name of the archive to which
the files will be added */
QString CAddFiles::getOtherArchiveName(){
	return leAddOther->text();
}

/** return the name of the archive to be created */
QString CAddFiles::getNewArchiveName(){
	return leCreate->text();
}

/** Validate the choice */
void CAddFiles::slotOk(){
	accept();
}

/** reject the choices */
void CAddFiles::slotCancel(){
	reject();
}

/** The dropped file is an archive, so modify
the dialog box. */
void CAddFiles::setCheckBoxArchive(){
	rbCreate->hide();
	bBrowseCreate->setEnabled(false);
	leCreate->hide();
	rbOpenArchive->setEnabled(true);
	rbOpenArchive->setChecked(true);
}

/** If karchiveur doesn't contain any archive,
	* disable the first radio button */
void CAddFiles::canAddToCurrentArchive(bool canAdd){
	if(!canAdd)
	{
		rbAddCurrent->setEnabled(false);
		rbCreate->setChecked(true);
        leCreate->setFocus();
	}
}

/*Set the default displayed archive name*/
void CAddFiles::setDefaultArchiveName(QString arch)
{
  leCreate->setText(arch);
  leCreate->setFocus();
  rbAddCurrent->setChecked(true);//Default choice: add dropped files to current archive
}

void CAddFiles::slotUpdateAddOther(const QString&)
{
  if(!rbAddOther->isChecked())
    rbAddOther->setChecked(true);
}

void CAddFiles::slotUpdateCreate(const QString&)
{
  if(!rbCreate->isChecked())
    rbCreate->setChecked(true);
}

void CAddFiles::slotSetFocus(int i)
{
  if(i==1)
    leAddOther->setFocus();
  else if(i==3)
    leCreate->setFocus();
}

#include "caddfiles.moc"
