/***************************************************************************
                          ccheckfiles.cpp  -  description
                             -------------------
    begin                : mar jan 20 2004
    copyright            : (C) 2004 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kfileitem.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qfileinfo.h>
#include <qpixmap.h>
#include <qdir.h>

#include "ccheckfiles.h"

bool CCheckFiles::overwrite=false;

CCheckFiles::CCheckFiles(){
  KIconLoader icon;
  setIcon(icon.loadIcon("karchiver",KIcon::Small));

  QGridLayout *grid = new QGridLayout(this,5,3,15,7);

  QLabel* label_1;
  label_1 = new QLabel( this, "Label_1" );
  label_1->setText( i18n("<qt>The following files from your archive will overwrite those\n on your disk. <b>Unselect from the list the files you do <i>not</i> want to extract.</b></qt>") );
  grid->addMultiCellWidget(label_1,0,0,0,2);

  files = new KListView( this, "ListView_files" );
  files->setSelectionMode(QListView::Multi);
  files->addColumn(i18n("Filename"));
  files->addColumn(i18n("File on disk"));
  files->addColumn(i18n("Size (Arch. / Disk)"));
  files->addColumn(i18n("Date (Arch. / Disk)"));
  grid->addMultiCellWidget(files,1,3,0,2);

  ok=new QPushButton(i18n("Proceed"), this, "button_ok");
  grid->addWidget(ok,4,1);
  connect(ok, SIGNAL(clicked()), SLOT(accept()));

  resize( 490,310 );
}

CCheckFiles::~CCheckFiles(){
}

/**Shall we always overwrite files ?*/
void CCheckFiles::setOverwrite(bool overwr)
{
  overwrite=overwr;
}

/** Check if file will overwrite a file on the disk (the extract directory must be provided
 * first with setExtractPath). Then  fills the listboxes */
void CCheckFiles::addFile(QStringList list){
  for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )  
    checkSafelyExtract(*it);
}

/** same as above */
void CCheckFiles::addFile(QString str){
  checkSafelyExtract(str);
}

/** same as above */
void CCheckFiles::addFile(QString& name, int& size, QDateTime& date){
//kdDebug()<<QString("CCheckfile::addFile name=%1, size=%1, date=%2").arg(name).arg(size).arg(date.toString())<<endl;
  checkSafelyExtract(name, size, date);
}

/** returns the files that can be extracted */
QStringList CCheckFiles::getFiles(){
  QStringList list;

  QListViewItem * subfiles = files->firstChild();
  while( subfiles ) {
    if(subfiles->isSelected())
      list.append(subfiles->text(0));
    subfiles = subfiles->nextSibling();
  }

  return list+filescanbeextracted;
}

/** Set the path where the files will be extracted */
void CCheckFiles::setExtractPath(QString str){
  QFileInfo fi(str);
  extractpath=str+"/";
  canwritebasepath=checkExtractPath(extractpath);
}

/** return true if the present file can be safely extracted, e.g. it will neither overwrite a file nor goes to an unwritable directory. If only @param name is provided, don't prompt any size/date indications*/
bool CCheckFiles::checkSafelyExtract(QString& name, unsigned int size, QDateTime date){
  if(name.startsWith("/"))
    name=name.remove(0,1);
  QString fullfilename=extractpath+name;
  QFileInfo info(fullfilename);
  QListViewItem *elementlist;

  if(!canwritebasepath)
  {
      KIconLoader icon;
      filescannotbeextracted.append(name);
      elementlist=new QListViewItem(files, name, i18n("Cannot write in this directory"));
      elementlist->setPixmap(0,icon.loadIcon("cancel",KIcon::Small));
      files->insertItem(elementlist);
      return false;
  }
  else if(info.exists())
  {
    if(!info.isWritable())
    {
      KIconLoader icon;
      filescannotbeextracted.append(name);
      elementlist=new QListViewItem(files, name, i18n("exists and not writable"), QString::number(size)+"/"+QString::number(info.size()), date.toString()+" / "+(info.created()).toString());
      elementlist->setPixmap(0,icon.loadIcon("cancel",KIcon::Small));
      files->insertItem(elementlist);
      return false;
    }
    else if(info.isWritable())
    {
      if(!overwrite)
      {
        KIconLoader icon;
        QString errormessage=i18n("exists,");
        QString messagedate;

      KMimeType::Ptr mimeType = KMimeType::findByPath( name, 0, true );
      QString pixmapname = mimeType->icon( name, true);
        
      if(info.size()>size)
        {
          errormessage+=" "+i18n("bigger size");
          pixmapname="karchiveur_diffsize";
        }
        else if(info.size()<size)
        {
          errormessage+=" "+i18n("smaller size");
          pixmapname="karchiveur_diffsize";
        }
        else
          errormessage+=" "+i18n("same size");
        if(date.isValid())
        {
          if(info.lastModified()>date)
          {
            errormessage+=" "+i18n("newer");
            pixmapname="karchiveur_newer";
          }
          else if(info.lastModified()<date)
          {
            errormessage+=" "+i18n("older");
            pixmapname="karchiveur_older";
          }
          else
            errormessage+=" "+i18n("same date");
          messagedate=date.toString();
        }
        else
          messagedate="???";
        filesaskbeforeextract.append(name);
        elementlist=new QListViewItem(files, name, errormessage, QString::number(size)+" / "+QString::number(info.size()), messagedate+"/"+(info.created()).toString());
        elementlist->setPixmap(0,icon.loadIcon(pixmapname, KIcon::Small));
        elementlist->setSelected(true);
        files->insertItem(elementlist);
      }
      else
        filescanbeextracted.append(name);
    }
  }
  else
    filescanbeextracted.append(name);

  return true;
}

/** return true if all the files can be extracted without any user action 
      otherwise, one should call exec() and then getFiles() to know which files
      are to be processed */
bool CCheckFiles::canSafelyExtract(){
  if(filesaskbeforeextract.isEmpty()&&filescannotbeextracted.isEmpty())
    return true;
  return false;
}

/** Check if the extract path exists. Otherwise, create it if possible */
bool CCheckFiles::checkExtractPath(QString d){
  QDir dir;
  QFileInfo f;
  dir.setPath(d);

  if(dir.exists())
  {
    f.setFile(d);
    if(f.isWritable())
      return true;
    else
      return false;
  }
  else
  {
    int pos=d.findRev("/");
    if(pos==-1)
      return false;

    if(checkExtractPath(d.left(pos)))
    {
      dir.setPath(d);
      dir.mkdir(d);
      return true;
    }
  }
  return false;  
}

#include "ccheckfiles.moc"
