/***************************************************************************
                          cextraction.h  -  description                              
                             -------------------                                         
    begin                : Fri Jun 4 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@hivaoa.unice.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CEXTRACTION_H
#define CEXTRACTION_H

#include <qwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qdir.h>
#include <qcheckbox.h>

#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>
#include <kcombobox.h>
#include <kcompletion.h>

#include "dirview.h"
#include "chistorique.h"
#include "resource.h"

/**
  *@author Eric Coquelle
  */

class CExtraction : public QDialog  {
   Q_OBJECT
public: 
   CExtraction(QDialog *parent=0, const char *name=0);
   ~CExtraction();
   /** Returns the last extract path */
   static QString & getLastExtractPath();
   /** Set predefined extract path */
   static void setDefaultOptions(QString& defaultExtractPath, int& defaultOptionExtract);
   /** View the extracted directory in Konqueror after extracting ? */
   bool viewExtractedDirectoryInKonqueror();
   /** Set the default directory */
   void setOptionExtraction(int optionExtract);
   /** Displays in the text box the default extraction direcrory */
   void displayDefaultPath();
   /**Returns a regular expression, to sort which files should be extracted */
   QString getRegExp();
   
   public slots:
     /* The path is OK, we can extract*/
     void doExtract();
   /* Close the dialog*/
   void dontExtract();
   /* Convert the recursive items from class Directory to a valid path*/
   void retrieve(QListViewItem*);
   /* Return 0 if all files have to be extracted*/
   int extractAll();
   
private:
   /*Tells which kind of default folder*/
   static int optionextract;
   /*The default path*/
   static QString m_defaultExtractPath;
   /*Used for reconstructing the path give by the dirview*/
   static QString path;
   
   QString options;
   QString fichiers;
   
   //GUI
   QListView* listView;
   Directory *directory;
   QPushButton *bextract;
   KHistoryCombo* cbExtractDirectory;
   QCheckBox* chLaunchKonqueror;
   QRadioButton* qtarch_RadioButton_1;
   QRadioButton* qtarch_RadioButton_2;
   QCheckBox* qtarch_cbregexp;
   QLineEdit* le_regexp;
   CHistory* history;

 protected: // Protected methods
   /** save the MRU entries */
   void writeHistory();
   /** set the Most Recent Used extract dirs */
   void setHistory();
};

#endif







