/***************************************************************************
                          cfiledialog.cpp  -  description
                             -------------------
    begin                : mer sep 24 2003
    copyright            : (C) 2003 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kurlcombobox.h>
#include <kfilefiltercombo.h>
#include <klocale.h>
#include <kdebug.h>
#include "cfileinfo.h"
#include "cfiledialog.h"

CFileDialog::CFileDialog(const QString& startDir, const QString& filter, QWidget *parent, const char *name, bool modal, QWidget* widget) : KFileDialog(startDir, filter, parent, name, modal, widget)
{  
  init();
}

CFileDialog::CFileDialog(const QString& startDir, const QString& filter, QWidget *parent, const char *name, bool modal) : KFileDialog(startDir, filter, parent, name, modal)
{
  init();
}

void CFileDialog::init()
{
  setFilter(filterlist());
  connect(locationEdit, SIGNAL(textChanged ( const QString& )),  SLOT(slotDialogNewArchiveFileSelected(const QString& )));
}

QString CFileDialog::filterlist()
{
  QString filter;
  filter+="*.tar.gz *.tgz *.Z|";
  filter+=i18n("targz archives");
  filter+="\n*.tar.bz2|";
  filter+=i18n("tarbz2 archives");
  filter+="\n*.tar|";
  filter+=i18n("tar archives");
  filter+="\n*.zip|";
  filter+=i18n("zip archives");
  filter+="\n*.rar|";
  filter+=i18n("rar archives");
  filter+="\n*.lha *.lzh|";
  filter+=i18n("lha archives");
  filter+="\n*.arj|";
  filter+=i18n("arj archives");
  filter+="\n*.gz|";
  filter+=i18n("gzip archives");
  filter+="\n*.bz2|";
  filter+=i18n("bzip2 archives");
  filter+="\n*.jar|";
  filter+=i18n("jar archives");
  filter+="\n*.7z|";
  filter+=i18n("7z archives");
  filter+="\n*.deb|";
  filter+=i18n("ar and deb archives");
  filter+="\n*.sit|";
  filter+=i18n("sit archives");
  filter+="\n*.hqx|";
  filter+=i18n("hqx archives");
  
  return filter;
}

CFileDialog::~CFileDialog(){
}

void CFileDialog::slotDialogNewArchiveFileSelected(const QString& file)
{
  QString currentarchivename;
  QFileInfo f(file);
  QString extension=f.extension().lower();

  if(f.extension().isEmpty())
    return;

  if((extension=="tar.gz")||(extension=="tgz"))
    filterWidget->setCurrentItem(0);
  else if(extension=="tar.bz2")
    filterWidget->setCurrentItem(1);
  else if(extension=="tar")
    filterWidget->setCurrentItem(2);
  else if(extension=="zip")
    filterWidget->setCurrentItem(3);
  else if(extension=="rar")
    filterWidget->setCurrentItem(4);
  else if((extension=="lha")||(extension=="lhz"))
    filterWidget->setCurrentItem(5);
  else if(extension=="arj")
    filterWidget->setCurrentItem(6);
  else if(extension=="gz")
    filterWidget->setCurrentItem(7);
  else if(extension=="bz2")
    filterWidget->setCurrentItem(8);
  else if(extension=="jar")
    filterWidget->setCurrentItem(9);
  else if(extension=="7z")
    filterWidget->setCurrentItem(10);
  else if((extension=="deb")||(extension=="ar"))
    filterWidget->setCurrentItem(11);
  else if(extension=="sit")
    filterWidget->setCurrentItem(12);
  else if(extension=="hqx")
    filterWidget->setCurrentItem(13);
}

/* If selected file doesn't have an extension, add one according to the selected filter*/
QString CFileDialog::fixFileExtension(QString& file)
{
  QString filter;
  CFileInfo f(file);
  
  if(f.extension().isEmpty()&&(!file.isEmpty()))
  {
    filter=currentFilter();
    if(filter=="*.tar.gz *.tgz *.Z")
      filter=".tar.gz";
    else if(filter=="*.tar.bz2")
      filter=".tar.bz2";
    else if(filter=="*.lha *.lzh")
      filter=".lha";
    else if(filter=="*.arj")
      filter=".arj";
    else if(filter=="*.rar")
      filter=".rar";
    else if(filter=="*.gz")
      filter=".gz";
    else if(filter=="*.bz2")
      filter=".bz2";
    else if(filter=="*.zip")
      filter=".zip";
    else if(filter=="*.tar")
      filter=".tar";
    file+=filter;
  }
  return file;
}

QString CFileDialog::getSaveFileName( const QString & startDir ,const QString & filter , QWidget * parent , const QString & caption )
{
  return KFileDialog::getSaveFileName( startDir , filterlist() );
}

#include "cfiledialog.moc"
