/***************************************************************************
                          chistorique.h  -  description
                             -------------------
    begin                : Wed Aug 23 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHISTORIQUE_H
#define CHISTORIQUE_H

#include <qstrlist.h>
#include <qstring.h>

/**This class stores a certain number of all differents elements
  *@author Eric Coquelle
  */

class CHistory {
public:
	CHistory();
	~CHistory();

  /** return an array that contains all the stored
		* elements */
  QStrList getElements();

  /** Add an item to the array. This method will
		* check if the element is not present in the
		* array, otherwise, do nothing */
  void addElement(QString element);
  /** return the current array element, i.e. its
first one */
  QString getCurrentElement();
  /** return the maximal history size */
  int getMaxElements();
  /** set the history size to max */
  void setMaxElements(int max);
  /** return the element at position idx */
  QString getElementAt(int idx);
  /** return the number of elements in the array */
  int getNumberOfElements();
  /** set the array elements to list */
  void setElements(QStrList list);

	
	
private:
	QStrList elements;
	unsigned int maxElements;
};

#endif
