/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cinfos.h"

#include <qfile.h>
#include <kmdcodec.h>


CInfos::CInfos(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	//Additionnal init
	KIconLoader icone;
	setIcon(icone.loadIcon("karchiver",KIcon::Small));

  connect(bOk, SIGNAL(clicked()), this, SLOT(slotOk()));

	setCaption(i18n("Archive information"));	
}

CInfos::~CInfos(){
}

/** Initialise the line edit widgets so that they display the
requested informations */
void CInfos::initialise(QString archivename, QStringList archivecomments, int nbFiles, int archiveSize, int filesSize, int filesMeanSize, int icompressrate, int sigma)
{
   QString str;
   KMD5 md5;
   QFile file(archivename);
   
   file.open(IO_ReadOnly);
   
   str.sprintf(" %d ",nbFiles);
   leNbfiles->setText(i18n("In this archive, there are:")+str+i18n("file(s)"));
   str.sprintf(" %d ",filesSize);
   leSizeOnDisk->setText(i18n("They will occupy")+str+i18n("bytes on disk"));
   str.sprintf(" %d ",archiveSize);
   leArchiveSize->setText(i18n("Archive size is")+str+i18n("bytes"));
   str.sprintf(" %d ",filesMeanSize);
   leMeanFileSize->setText(i18n("Medium file size is:")+str+i18n("bytes"));
   
   if(icompressrate<0)//Happens when files of some bytes are compressed...
     icompressrate=0;
   compressrate->setProgress(icompressrate, 100);
   str.setNum(sigma);
   leSigma->setText(str);
   
   md5.update(file);
   leMd5->setText(md5.hexDigest());
   
   for(QStringList::Iterator it =archivecomments.begin();it!=archivecomments.end();it++)
      log->append(*it);
   
   
}

/** close the dialog box */

void CInfos::slotOk(){
	accept();
}
#include "cinfos.moc"
