/***************************************************************************
                          clha.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "clha.h"
#include <kdebug.h>
#include <qdir.h>

CLha::CLha(){
  CArchive();

  connect(&processread,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOut(KProcess*,char*,int)));
  connect(&processread,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processextract,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract, SIGNAL(receivedStderr(KProcess *, char *, int)),this, SLOT(haveSdtErrExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));

  list->setColumnText(4, i18n("Owner"));
  list->setColumnText(5, i18n("Permissions"));
}

CLha::~CLha(){
}

/** this method will launch the right compressor
to list the file contents
It will then launch the right method to display
the content in the listview */
void CLha::displayArchiveContent(){
	FILE *flot;

	initializeReadingArchive();

	processread << "lha";
	processread << "l" << archiveName;

	if(readArchiveWithStream)
	{
		processread.start(&flot,KProcess::AllOutput);
		displayLhaArchiveContent(flot);
	}
	else
	{
		m_buffer[0]='\0';
		processread.start(KProcess::NotifyOnExit, KProcess::AllOutput);
	}
}

/** display in a listview the content of the current
lha archive. This method examines the stdout of
unarj to sort useful infos for the listview */
void CLha::displayLhaArchiveContent( FILE* flot ){
	CListViewItem* elementListe;
	char tampon[5000];
	char permission[30];
	char owner[256];
	char crc[20];
	char size[30];
	char date[12];
	char hour[7];
	char sname[5000];
	QString path;
	QString name;
	QString message;
	int i;

	do
		fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "--------------------" )==NULL));
	fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "----" )==NULL))
	{
		sscanf(tampon, " %[MSDOdrwxst-] %[0-9a-zA-Z/] %[0-9] %[*.0-9%] %[a-zA-Z] %[0-9-] %[0-9:] %[^\n]", permission, owner, size, crc, crc, date, hour, sname );

		name=sname;
		name=" "+name;
		i=name.findRev('/');
		if(i!=-1)
		{
			path=name.left(i+1);
		 	name=name.remove(0,i+1);
		if(name=="")
			name="..";
		}
		else
			path="";

		elementListe=new CListViewItem(list,name,size,hour,date,owner,permission,path);
		setIcon(name, permission, elementListe);
		elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
	fclose( flot );
}

/*Overloaded method*/
void CLha::displayLhaArchiveContent( const char* line){
  CListViewItem* elementListe;
  char permission[30];
  char owner[256];
  char crc[20];
  char size[30];
  char date[12];
  char hour[7];
  char sname[5000];
  QString path;
  QString name;
  QString message;
  int i;

  sscanf(line, " %[drwxst-] %[0-9a-zA-Z/] %[0-9] %[*.0-9%] %[a-zA-Z] %[0-9-] %[0-9:] %[^\n]", permission, owner, size, crc, crc, date, hour, sname );

  name=sname;
  i=name.findRev('/');
  if(i!=-1)
  {
          path=name.left(i+1);
          name=name.remove(0,i+1);
  if(name=="")
          name="..";
  }
  else
          path="";

  elementListe=new CListViewItem(list,name,size,hour,date,owner,permission,path);
  setIcon(name, permission, elementListe);
  elementListe->widthChanged();
}

/** we recive some informations through the standard
output of the process */
void CLha::haveSdtOut(KProcess *, char *buffer, int length){
	//Has user canceled current action ?
	if(stopreadprocess)
		return;

	// This section is here only for testing. It has been taken from ark:
	//1997-1999: Rob Palmbos palm9744@kettering.edu
	//2000: Corel Corporation (author: Emily Ezust, emilye@corel.com)
	//and adapted to karchiveur
	int passage;
  char c = buffer[length];
  buffer[length] = '\0';

//  m_settings->appendShellOutputData( buffer );

  char line[1024] = "";
  char *tmpl = line;
  char *tmpb;


  //We copy m_buffer to tmpl
  for( tmpb = m_buffer; *tmpb != '\0'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  //We copy the fisrt string of buffer (till \n) to tmpl
  for( tmpb = buffer; *tmpb != '\n'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  tmpb++;
  *tmpl = '\0';

  if( *tmpb == '\0' )
    m_buffer[0]='\0';

	if((strncmp(line," PERMSSN",8)!=0)&&(strncmp(line,"----------",10)!=0))
  	displayLhaArchiveContent( line );

  bool stop = (*tmpb == '\0');
  passage=0;

  while( !stop)
  {
      tmpl = line; *tmpl = '\0';

      for(; (*tmpb!='\n') && (*tmpb!='\0'); tmpl++, tmpb++)
				*tmpl = *tmpb;

      if( *tmpb == '\n' )
			{
			  *tmpl = '\n';
			  tmpl++;
			  *tmpl = '\0';
			  tmpb++;

	  	if((passage<1)&&(strncmp(line," PERMSSN",8)!=0)&&(strncmp(line,"----------",10)!=0))
	  		displayLhaArchiveContent( line );
  		else
  			passage++;
			}
      else if (*tmpb == '\0' )
			{
	  		*tmpl = '\0';
			  strcpy( m_buffer, line );
	  		stop = true;
			}
    }
  buffer[length] = c;
}

/** we recive some informations through the standard
	* output of the process */
void CLha::haveSdtOutExtract(KProcess *, char *buffer, int length){
	QString inter;
	int i=0;

	inter=buffer;
	inter=inter.left(length);

	while((i=inter.find('\n',i+1))!=-1){
		progressbar->setProgress(progressbar->progress()+1);
	}
}

/** The current process ended */
void CLha::endProcess(KProcess*){
  kdDebug()<<("Process ENDED\n");

  emit(archiveReadEnded());
}

/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@toutextraire = 9: extract to karchiveur's temp directory (for viewing)
	*@toutextraire = 1: extract all selected files
	*/
void CLha::extractArchive(QString &extractpath, int extractall, QString & filetoextract){
 	QString directoryOption;
 	QString nameextrait;

        errors.clear();
	directoryOption="";
	counter=0;
	progressbar->reset();
	progressbar->setTotalSteps(list->childCount());

	processextract.clearArguments();
	processextract << "lha";

	directoryOption="-xw";
	directoryOption+=extractpath;
	processextract << directoryOption;
	if(!overwrite)
		processextract << "-f";

 	processextract << archiveName;

  if((extractall!=EXTRACTONE)&&(extractall!=EXTRACTONE_AND_BLOCK)&&(!checkFiles(extractpath, extractall)))
  {
    endProcess(NULL);
    return;
  }
  else if(extractall==EXTRACTONE_AND_BLOCK)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::Block)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall==EXTRACTONE)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::NotifyOnExit)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall!=EXTRACTONE_AND_BLOCK)
  {
          //We extract through the Stdout to have a progress indicator
    if(processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  counter=0;
}

/** delete @param filestodelete from current archive */
void CLha::removeFilesFromArchive (QStringList filestodelete){
 	processread.clearArguments();
 	processread << "lha" << "-d";
 	processread << archiveName;
  for (QStringList::Iterator f = filestodelete.begin(); f!=filestodelete.end(); ++f )
  {
    kdDebug()<<QString("Will remove:%1 from %2").arg(*f).arg(archiveName)<<endl;
    processread << *f;
  }
  processread.start(KProcess::Block);
}

/** Add some files to the archive
@param filestoadd : list of files to add
@param removeoriginalfiles : remove or not those files from disk
@param action : 0=mode append and replace files, 1=mode update files
@param relativepath : if !NULL, include only filenames, without their base path */
void CLha::addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath){
	QString s;

	if(relativepath!=NULL)
		QDir::setCurrent(relativepath);

	processadd.clearArguments();
	processadd << "lha";
	if(removeoriginalfiles)
		processadd << "-d";
	/* Not supported by lha
	if(recursivemode)
		processread << "-r";*/
	switch(action)
	{
   case UPDATE_FILES:
			//Mode update
			processadd << "-u";
			break;
		default:
   case ADD_AND_REPLACE_FILES:
			processadd << "-a";
			break;
	}

	processadd << archiveName;
	for (QStringList::Iterator f = filestoadd.begin(); f!=filestoadd.end(); ++f )
	{
	  s=*f;
	  if(s.endsWith("/") )
	    s.truncate(s.length()-1);
	  if(s.startsWith("file:"))
	    s.remove(0,5);
	  kdDebug()<<QString("Add Lha:%1*in:%2*").arg(s).arg(archiveName)<<endl;
  	processadd << s;
	}
	processadd.start(KProcess::NotifyOnExit);
}

/** Create a lha archive
@param  nameofarchive: the name of the zip archive
@param param: list of files to add
@param relativepath: include only filenames, without their path */
void CLha::createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath) {
	QString str;

	archiveName=nameofarchive;
	kdDebug()<<QString("DebutCreationLha*%1*%2*").arg(nameofarchive).arg(relativepath)<<endl;
	addFilesToArchive(filestoadd, false, 0,relativepath);
	kdDebug()<<("\nEndCreateLha\n");
}

/** perform an integrity check...*/
void CLha::testCurrentArchiveIntegrity()
{
  processextract.clearArguments();
  processextract << "lha" << "t" << archiveName;
  processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput);
}


#include "clha.moc"
