/***************************************************************************
                          clistview.cpp  -  description
                             -------------------
    begin                : Tue Jun 27 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "clistview.h"

CListView::CListView(QWidget *parent, const char *name) : KListView(parent,name){
  mousebuttonpressed=false;
  setAcceptDrops(true);
}

CListView::CListView(){
  mousebuttonpressed=false;
}

CListView::~CListView(){
}

/** Intercept mouse moves to allow drag&drop */
void CListView::contentsMouseMoveEvent( QMouseEvent * e){
  if((mousebuttonpressed)&&((e->x()<0)||(e->x()>width())||(e->y()<0)||(e->y()>height())))
  {
		initiateDragAndDrop();
        mousebuttonpressed=false;
  }
  else
    QListView::contentsMouseMoveEvent( e );
}

/** Start the drag and drop operations by: extracting the
right files, and then send a list of filenames
to the target application */
void CListView::initiateDragAndDrop(){
	emit doDragAndDrop();
}

/**  */
void CListView::contentsMousePressEvent( QMouseEvent * e){
  if(e->button()==LeftButton)
   mousebuttonpressed=true;
  QListView::contentsMousePressEvent( e );
}

/**  */
void CListView::contentsMouseReleaseEvent( QMouseEvent * e){
  mousebuttonpressed=false;
  QListView::contentsMouseReleaseEvent( e );
}

#include "clistview.moc"
