/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "crecherche.h"

CSearch::CSearch(QDialog *parent, const char *name ) : QDialog(parent,name,TRUE)
{
  QGridLayout *grid1 = new QGridLayout(this,6,4,15,7);
  listView = new QListView( this, "ListView_1" );
  listView->setFocusPolicy( QWidget::TabFocus );
  listView->setBackgroundMode( QWidget::PaletteBackground );
  listView->setFrameStyle( 0 );
  listView->setLineWidth( 1 );
  listView->setMidLineWidth( 0 );
  listView->QFrame::setMargin( 0 );
  listView->setResizePolicy( QScrollView::Manual );
  listView->setVScrollBarMode( QScrollView::Auto );
  listView->setHScrollBarMode( QScrollView::Auto );
  listView->setTreeStepSize( 20 );
  listView->setMultiSelection( FALSE );
  listView->setAllColumnsShowFocus( FALSE );
  listView->setItemMargin( 1 );
  listView->setRootIsDecorated( FALSE );
  listView->addColumn( i18n("Where to search:"), -1 );
  listView->setColumnWidthMode( 0, QListView::Maximum );
  listView->setColumnAlignment( 0, 1 );
  grid1->addMultiCellWidget(listView,0,5,0,0);

  directory=new Directory(listView);
  directory->setOpen(TRUE);
  connect(listView, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(retrieve(QListViewItem*)));

  qtarch_LineEdit_1 = new QLineEdit( this, "LineEdit_1" );
  grid1->addMultiCellWidget(qtarch_LineEdit_1,0,0,2,3);
  qtarch_LineEdit_1->setFocusPolicy( QWidget::StrongFocus );
  qtarch_LineEdit_1->setBackgroundMode( QWidget::PaletteBase );
  qtarch_LineEdit_1->setText( "" );
  qtarch_LineEdit_1->setMaxLength( 32767 );
  qtarch_LineEdit_1->setFrame( QLineEdit::Normal );
  qtarch_LineEdit_1->setFrame( TRUE );

  foundarchives = new QListBox(this,"listBox_archives_trouvees");
  grid1->addMultiCellWidget(foundarchives,1,3,1,3);

  QLabel* qtarch_Label_1;
  qtarch_Label_1 = new QLabel( this, "Label_1" );
  qtarch_Label_1->setFocusPolicy( QWidget::NoFocus );
  qtarch_Label_1->setBackgroundMode( QWidget::PaletteBackground );
  qtarch_Label_1->setFrameStyle( 0 );
  qtarch_Label_1->setLineWidth( 1 );
  qtarch_Label_1->setMidLineWidth( 0 );
  qtarch_Label_1->QFrame::setMargin( 0 );
  qtarch_Label_1->setText( i18n("Search in:") );
  qtarch_Label_1->setAlignment( 289 );
  qtarch_Label_1->setMargin( -1 );
  grid1->addWidget(qtarch_Label_1,0,1);

  QGridLayout *grid2 = new QGridLayout(1,9);
  grid1->addMultiCellLayout(grid2,4,4,1,2);
  /*aditional init*/
  led1=new KLed(KLed::green,this,"led1");
  grid2->addWidget(led1,0,0);

  led2=new KLed(KLed::green,this,"led2");
  grid2->addWidget(led2,0,1);

  led3=new KLed(KLed::green,this,"led3");
  grid2->addWidget(led3,0,2);

  led4=new KLed(KLed::green,this,"led4");
  grid2->addWidget(led4,0,3);

  led5=new KLed(KLed::green,this,"led5");
  grid2->addWidget(led5,0,4);

  initLeds();

  bextraire=new QPushButton(i18n("Search"), this, "bd_search");
  grid1->addWidget(bextraire,5,2);
  // bextraire->setFont( QFont( "Times", 18, QFont::Bold ) );
  connect(bextraire, SIGNAL(clicked()), SLOT(slotStartSearch()));

  QPushButton *bannulle;
  bannulle=new QPushButton(i18n("Close"), this, "pb_cancel");
  grid1->addWidget(bannulle,5,3);
  connect(bannulle, SIGNAL(clicked()), SLOT(noExtraction()));

  resize( 490,310 );
  path="";
  stade=0;

  connect(&processrecherche, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(recueStdout(KProcess*, char*, int)));
  connect(&processrecherche, SIGNAL(processExited(KProcess*)), this, SLOT(endProcess(KProcess*)));

}

CSearch::~CSearch(){
}

void CSearch::retrieve(QListViewItem *l)
{
	if(l->depth()!=0)
	{
		path="/"+path;
		path=l->text(0)+path;
		retrieve(l->parent());
	}
	else
	  {
		path="/"+path;
		qtarch_LineEdit_1->setText( path );
		path="";
	}
}

QString CSearch::getPath()
{
	return path;
}

void CSearch::noExtraction()
{
	reject();
}

void CSearch::setPath(const char* path, int optionExtract){
	switch(optionExtract)
	{
		case 0:
			qtarch_LineEdit_1->setText(path);
			break;
		case 1:
			qtarch_LineEdit_1->setText(QDir::homeDirPath());
			break;
		case 2:
			qtarch_LineEdit_1->setText(QDir::currentDirPath());
			break;
	}
}

/** Start the search */
void CSearch::slotStartSearch(){
	path=qtarch_LineEdit_1->text();

	if(path.isEmpty())
		return;

	initLeds();
	stade=1;
	foundarchives->clear();
	processrecherche.clearArguments();
	processrecherche << "find";
	processrecherche << path;
	processrecherche << "-iname";
	processrecherche << "*.gz";
	processrecherche.start(KProcess::NotifyOnExit, KProcess::Stdout);
}

/** The process ended */
void CSearch::endProcess(KProcess*)
{
	processrecherche.clearArguments();
	processrecherche << "find";
	processrecherche << path;
	processrecherche << "-iname";
	stade++;
	switch(stade)
	{
		case 2:
			led1->setState(KLed::On);
		  processrecherche << "*.bz2";
		  break;
		case 3:
			processrecherche << "*.tgz";
			break;
		case 4:
			led2->setState(KLed::On);
			processrecherche << "*.tar.Z";
			break;
		case 5:
			led3->setState(KLed::On);
			processrecherche << "*.zip";
			break;
		case 6:
			processrecherche << "*.lha";
			break;
		case 7:
			processrecherche << "*.rar";
			break;
   case 8:
     processrecherche << "*.arj";
     break;
   case 9:
     processrecherche << "*.sit";
     break;
   case 10:
     processrecherche << "*.hqx";
     break;
   case 11:
			led4->setState(KLed::On);
			processrecherche << "*.deb";
			break;
		case 12:
			led5->setState(KLed::On);
			stade=0;
			return;
			break;
		default:
			return;
			break;
	}

	processrecherche.start(KProcess::NotifyOnExit, KProcess::Stdout);
}

/** output of the process */
void CSearch::recueStdout(KProcess* /*p*/, char* buffer, int len)
{
	QString str;
	int i;

	str="";
	for(i=0;i<len;i++)
	{
		if(buffer[i]=='\n')
		{
			foundarchives->insertItem(str);
			str="";
		}
		else
			str+=buffer[i];
	}
}

/** Set all leds to green, state=off */
void CSearch::initLeds()
{
	led1->setState(KLed::Off);
	led1->setColor(KLed::green);
	led2->setState(KLed::Off);
	led2->setColor(KLed::green);
	led3->setState(KLed::Off);
	led3->setColor(KLed::green);
	led4->setState(KLed::Off);
	led4->setColor(KLed::green);
	led5->setState(KLed::Off);
	led5->setColor(KLed::green);
}
#include "crecherche.moc"
