/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : Thu Mar  2 20:36:53 CET 2000
    copyright            : (c) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CSCRIPT_H
#define CSCRIPT_H


#include "cwizardmainpage.h"
#include "cwizardstep3.h"
#include "cwizardstep1patch.h"
#include "cwizardinstallation.h"
#include "cwizardconversion.h"
#include "cwizardcutt.h"
#include "cwizardsfx.h"

/**This class runs a serie of wizards and then
execute the appropriates commands: apply a
patch, install a software (i.e. configure, make ...)
  *@author Eric Coquelle
*/

class CScript {

public: 
  CScript();
  ~CScript();
  
  /** Start the wizard operations)*/
  int startWizard(QString, QString, QString);
  /** Return the directory where to store the
      converted archive */
  QString getDirectoryConversion();
  /** return the conversion format */
  int getTypeConversion();
  /* Return the directory or file for cutt/uncutt operations.
     Needs to probe a .01 extension */
  QString getDirectoryCutt();
  /** Return the size of a block of a huge file */
  int getCuttSize();
  int getSfxArchiveType() {return sfxtype;};
  QString getSfxArchiveName() {return sfxname;};
  
protected:
  int mainwizardpage();

public:
  enum {WIZ_PATCH, WIZ_INSTALLATION, WIZ_CONVERSION, WIZ_UNCUTT, WIZ_SFX};
  
private:
  /*The main wizard window*/
  CWizardMainPage wizmainpage;
  /* The selected file used for patching */
  QString fichselect;
  /* Where files are located*/
  QString repbase;
  /*Current archive name*/
  QString archivename;
  QString reppatch;
  QString targetdirectoryconversion;
  int targettypeconversion;
  QString targetdirectorycutt;
  int cuttsize;
  int sfxtype;
  QString sfxname;
};

#endif
