/***************************************************************************
                          ctar.h  -  description
                             -------------------
    begin                : Tue Dec 19 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTAR_H
#define CTAR_H

#include "carchive.h"

#include <ktar.h>

/**This class will manage all pure Tar archives
  *@author Eric Coquelle
  */

class CTar : public CArchive  {
    Q_OBJECT
public:
	CTar();
	~CTar();

	/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@param extractall = 9: extract to karchiveur's temp directory (for viewing)
	*@param extractall = 1: extract all selected files
	*/
	void extractArchive(QString & extractpath, int extractall, QString & filetoextract);
  /** delete @param filestodelete from current archive */
  void removeFilesFromArchive (QStringList filestodelete);
  /** Add some files to the archive
     @param filestoadd : list of files to add
     @param removeoriginalfiles : remove or not those files from disk
     @param action : 0=mode append and replace files, 1=mode update files
     @param relativepath : if !NULL, include only filenames, without their base path */
  void addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath=NULL);
  /** Create a tar archive
  @param  nameofarchive: the name of the pure .tar archive
  @param param: list of files to add
  @param relativepath: include only filenames, without their path */
  void createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath=NULL);
  /*Returns true as tar-based archives cann be listed by KIO*/
  bool supportDisplayByDirs(){return true;};

protected:
  /** this method will launch the right compressor
	to list the file contents
	It will then launch the right method to display
	the content in the listview */
  void displayArchiveContent();
  /** This method display, using some (fine ?) icons
      the content of the current archive */
  void displayTarArchiveContent(FILE* flot);
  /*Overloaded method*/
  void displayTarArchiveContent(const QString &);

protected slots:
	/** we recive some informations through the standard
		output of the process */
	void haveSdtOut(KProcess *prpc, char *buffer, int length);
	/* Same thing for the extraction process*/
	void haveSdtOutExtract(KProcess *prpc, char *buffer, int length);
	/** The current process ended */
	virtual void endProcess(KProcess*);

protected:  
  KTar *tarfile;
};

#endif
