/***************************************************************************
                          ctarbz2.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ctarbz2.h"
#include <kdebug.h>

CTarBz2::CTarBz2(){
	CTar();
}

CTarBz2::~CTarBz2(){
}

/** this method will launch the right compressor
to list the file contents
It will then launch the right method to display
the content in the listview */
void CTarBz2::displayArchiveContent(){
  initializeReadingArchive();
  
  if(viewbydirectories)
    CTar::displayArchiveContent();
  else
  {
    FILE *flot;

  	initializeReadingArchive();

  	processread << "tar";
  	processread << "--use-compress-program=bzip2" << "-vtf" << archiveName;

  	if(readArchiveWithStream)
  	{
  			processread.start(&flot,KProcess::AllOutput);
  			displayTarArchiveContent(flot);
  	}
  	else
  	{
  		m_buffer[0]='\0';
  		processread.start(KProcess::NotifyOnExit, KProcess::AllOutput);
  	}
  }
}

/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@toutextraire = 9: extract to karchiveur's temp directory (for viewing)
	*@toutextraire = 1: extract all selected files
	*/
void CTarBz2::extractArchive(QString &extractpath, int extractall, QString & filetoextract){
kdDebug()<<QString("CTarBz2::extractArchive %1 in %2, extrall=%3").arg(archiveName).arg(extractpath).arg(extractall)<<endl;
 	QString optionRepertoire;
 	QString nomextrait;
 	QString fichiersaextraire;
  QStringList listsubdir;

 	optionRepertoire="";
 	fichiersaextraire="";
 	counter=0;
 	progressbar->reset();

  processextract.clearArguments();
  processextract << "tar";

  optionRepertoire="-C";
  optionRepertoire+=extractpath;
  processextract << "--use-compress-program=bzip2";
  processextract << "--overwrite"; //user select the files that have to be extracted in checkFiles(extractpath, extractall)
  processextract << "-vxf";

  processextract << archiveName;
  processextract << optionRepertoire;

  //We will extract all selected files
  if((extractall!=EXTRACTONE)&&(extractall!=EXTRACTONE_AND_BLOCK)&&(!checkFiles(extractpath, extractall)))
  {
    endProcess(NULL);
    return;
  }
  else if(extractall==EXTRACTONE_AND_BLOCK)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::Block)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall==EXTRACTONE)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::NotifyOnExit)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall!=EXTRACTONE_AND_BLOCK)
  {
          //We extract through the Stdout to have a progress indicator
          if(processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput)==FALSE)
            kdDebug()<<("\n*PB PROCESS*\n");
  }
  counter=0;
}

/** delete @param filestodelete from current archive */
void CTarBz2::removeFilesFromArchive( QStringList filestodelete )
{
  processextract.clearArguments();
  processextract << "bzip2" << "-df" << archiveName;
  processextract.start(KProcess::Block);

  //The name of archive arch.tar.bz2 is now arch.tar
  archiveName=archiveName.left(archiveName.length()-4);
  CTar::removeFilesFromArchive(filestodelete);

  processread.clearArguments();
  processread << "bzip2" << "-f" << QString("-%1").arg(compressrate) << archiveName;
  processread.start(KProcess::Block);
  archiveName+=".bz2";
}

/** Add some files to the archive
@param filestoadd : list of files to add
@param removeoriginalfiles : remove or not those files from disk
@param action : 0=mode append and replace files, 1=mode update files
@param relativepath : if !NULL, include only filenames, without their base path */
void CTarBz2::addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath){
    KProcess processcompressgz;

    processcompressgz.clearArguments();
    processcompressgz << "bzip2" << "-df" << archiveName;
    processcompressgz.start(KProcess::Block);

    //The name of archive arch.tar.bz2 is now arch.tar
    archiveName=archiveName.left(archiveName.length()-4);

    //We add files to the pure tar archive
    CTar::addFilesToArchive(filestoadd, removeoriginalfiles, action, relativepath);
}

void CTarBz2::createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath)
{
    archiveName=nameofarchive;

    //The name of archive arch.tar.bz2 is now arch.tar
    archiveName=archiveName.left(archiveName.length()-4);

    //We add files to the pure tar archive
    CTar::addFilesToArchive(filestoadd, false, ADD_AND_REPLACE_FILES, relativepath);
    kdDebug()<<("CTarBz2::createArchive ADD to TAR OK\n");
}

void CTarBz2::compressCreatedTarArchive()
{
  kdDebug()<<QString("CTarBz2::compressCreatedTarArchive %1 to bz2").arg(archiveName)<<endl;
    QString comprrate;
    KProcess processcompressgz;
    comprrate.sprintf("-%i",compressrate);

    processcompressgz.clearArguments();
    processcompressgz << "bzip2" << "-f" << comprrate << archiveName;
    processcompressgz.start(KProcess::Block);

    archiveName+=".bz2";
    emit(archiveReadEnded());
}

/** The current process ended */
void CTarBz2::endProcess(KProcess* p){
  kdDebug()<<("CTarBz2 Process ENDED\n");

  if((p!=NULL)&&(processadd.pid()!=0)&&(p->pid()==processadd.pid()))
    compressCreatedTarArchive();
  else
    emit(archiveReadEnded());
}

#include "ctarbz2.moc"
