/***************************************************************************
                          cupdate.cpp  -  description
                             -------------------
    begin                : jeu mai 1 2003
    copyright            : (C) 2003 by eric
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kio/netaccess.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kprocess.h>

#include <qfile.h>
#include <qsimplerichtext.h>


#include "cupdate.h"
#include "resource.h"


CUpdate::CUpdate(QWidget *parent, const char *name ) : QWidget(parent,name) {
}
CUpdate::~CUpdate(){
}

/** Retrieves the Changelog and check if a new version is available */
void CUpdate::checkUpdate(){
 QString current_version;
 QString tmpFile;
 QFile file;
 QTextStream stream;
 QString changelog;
 QString messageversion;
 int i;
 
 current_version="* v";
 current_version+=VERSION;
 current_version+"\n";
 if( KIO::NetAccess::download( KURL("http://perso.wanadoo.fr/coquelle/karchiver/ChangeLog"), tmpFile, this ) )
 {
   file.setName(tmpFile);
   file.open( IO_ReadOnly );
   stream.setDevice(&file);
   changelog=stream.read();
   i=changelog.find(current_version);
   //ChangeLog contains a welcome message. Changes begins at the 60th character;
   //Just a quick test, I will use regexp later
   messageversion=i18n("A new version is available")+changelog.mid(61,changelog.find('\n',61)-61);
   if((i==-1)||(i==60))
     KMessageBox::sorry(this,i18n("Your version is up to date"),i18n("KArchiver Update"));
   else
   {
     KMessageBox::detailedSorry(this,messageversion,changelog.mid(60,i-60),i18n("KArchiver Update"));
     if(KMessageBox::questionYesNo(this,i18n("Download it now?"),i18n("KArchiver Update"))==KMessageBox::Yes)
     {
       KProcess proc;
       proc << "konqueror" << "http://perso.wanadoo.fr/coquelle/karchiver/get_karchiver.html";
       proc.start(KProcess::DontCare);
     }
   }
   
   KIO::NetAccess::removeTempFile( tmpFile );
 }
 else
   KMessageBox::sorry(this, i18n("Network connection failed.\nCheck for updates at http://freshmeat.net or\nhttp://apps.kde.com"), i18n("KArchiver Update"));
}

#include "cupdate.moc"
