/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) 2005 by Eric Coquelle                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardcutt.h"

#include <kapplication.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <qlayout.h>
#include <qdir.h>


CWizardCutt::CWizardCutt(QWidget *parent, const char *name) : KWizard(parent,name,true){

  setupPageOne();
  setupPageTwo();
  //Additionnal init
  setCaption(i18n("KArchiver Split Wizard"));

  slotActiveTexte(0);
  connect(QButtonGroup_1, SIGNAL(clicked(int)), this, SLOT(slotActiveTexte(int)));
}

CWizardCutt::~CWizardCutt(){
}


void  CWizardCutt::setupPageOne(){
  QWidget *pageone = new QWidget(this);

  QGridLayout* layout=new QGridLayout(pageone, 5, 4, 16);

  QLabel* QLabel_Wiz= new QLabel(pageone,"WizardPic");
  QLabel_Wiz->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout->addMultiCellWidget(QLabel_Wiz, 0, 4, 0, 1);

  QLabel* QLabel_2= new QLabel(pageone,"PageOneTitle");
  QLabel_2->setText("<qt><h1>"+i18n("Split / Unsplit the archive")+"</h1></qt>");
  layout->addMultiCellWidget(QLabel_2, 0, 0, 2, 3);

  //layout->addRowSpacing(1, 8);
  
  QLabel* QLabel_3= new QLabel(pageone,"textpageone");
  QLabel_3->setText("<qt><p>"
                    +i18n("This wizard let you to split or unsplit an archive, so that it can fit into a floppy, a mail, or anything else.")
                    +"</p></qt>");
  layout->addMultiCellWidget(QLabel_3, 1, 4, 2, 3);

  
  addPage(pageone, i18n("KArchiver cutt/uncutt wizard - step 1"));
  setHelpEnabled(pageone, false);
}

void  CWizardCutt::setupPageTwo(){
  QWidget *pagetwo = new QWidget(this);

  QGridLayout *layout2=new QGridLayout(pagetwo, 5, 4, 8);

  QLabel* QLabel_Wiz= new QLabel(pagetwo,"Karchiver_Wizard_CWS2");
  QLabel_Wiz->setPixmap(UserIcon("karchiveur_wizard_large"));
  layout2->addMultiCellWidget(QLabel_Wiz, 0, 3, 0, 1);

  QLabel* QLabel_2= new QLabel(pagetwo,"NoName");
  QLabel_2->setText("<qt><h1>"+i18n("Split / Unsplit an archive")+"</h1></qt>");
  layout2->addMultiCellWidget(QLabel_2, 0, 0, 2, 3);

  QButtonGroup_1= new QButtonGroup(pagetwo,"NoName");
  QButtonGroup_1->setTitle(i18n("I Want To"));
  layout2->addMultiCellWidget(QButtonGroup_1, 1, 1, 2, 3);
  QGridLayout *box=new QGridLayout(QButtonGroup_1, 3, 2, 16);

      QRadioButton_1= new QRadioButton(QButtonGroup_1,"NoName");
      QRadioButton_1->setText(i18n("Split my current archive"));
      QRadioButton_1->setChecked(true);
      box->addMultiCellWidget(QRadioButton_1, 0, 0, 0, 1);

      spSize = new QSpinBox( QButtonGroup_1,"spin_split_size");
      spSize->setRange(1,200000);
      spSize->setValue(1416);
      box->addWidget(spSize, 1, 0);

      cmbSize = new QComboBox( QButtonGroup_1,"spin_combo");
      cmbSize->insertItem(i18n("byte"));
      cmbSize->insertItem(i18n("Kb"));
      cmbSize->insertItem(i18n("Mb"));
      cmbSize->setEditable(false);
      cmbSize->setCurrentItem(1);
      box->addWidget(cmbSize, 1, 1);

      QRadioButton_2= new QRadioButton(QButtonGroup_1,"NoName");
      QRadioButton_2->setMinimumSize(0,0);
      QRadioButton_2->setText(i18n("Unsplit and open an archive"));
      box->addMultiCellWidget(QRadioButton_2, 2, 2, 0, 1);


  labelLastStep= new QLabel(pagetwo,"NoName");
  labelLastStep->setAlignment(Qt::WordBreak);
  layout2->addMultiCellWidget(labelLastStep, 2, 3, 2, 3);

  addPage(pagetwo, QString("KArchiver cutt/uncutt wizard - step 2"));
  setHelpEnabled(pagetwo, false);
  setFinishEnabled(pagetwo, true);
}

void CWizardCutt::setNoneArchiveOpened()
{
    QRadioButton_1->setEnabled(false);
    QRadioButton_2->setChecked(true);
}

/** Set an appropriate text to the labels */
void CWizardCutt::slotActiveTexte(int)
{
    if(QRadioButton_1->isChecked())
    {
      labelLastStep->setText(i18n("Last step: please choose where to store the split files"));
      spSize->setEnabled(true);
      cmbSize->setEnabled(true);
    }
    else
    {
      labelLastStep->setText(i18n("Last step: please choose the first split file (ends with .01)"));
      spSize->setEnabled(false);
      cmbSize->setEnabled(false);
    }
}

/* Get the directory where to store the splited files */
void CWizardCutt::directoryChoice()
{
    QDir d;
    
    filechoice=KFileDialog::getExistingDirectory(QDir::homeDirPath(),this,i18n("Where to store split files?"));

    d.setPath(filechoice);
    if(d.isReadable())
        QDialog::accept();
    else
        QDialog::reject();
}

/* Get the first of the splited files */
void CWizardCutt::fileChoice()
{
    filechoice=KFileDialog::getOpenFileName (NULL, "*.01");
    
    if(!filechoice.isNull())
        QDialog::accept();
    else
        QDialog::reject();
}

void CWizardCutt::accept()
{
  if(QRadioButton_1->isChecked())
        directoryChoice();
    else
        fileChoice();
}

#include "cwizardcutt.moc"
