/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CWIZARDSTEP3_H
#define CWIZARDSTEP3_H

#include <kprocess.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kapp.h>
#include <klocale.h>
#include <qdialog.h>
#include <qdir.h>
#include <kiconloader.h>

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qpushbutton.h>
//Generated area. DO NOT EDIT!!!(end)


#include "kled.h"

#define CONFIGURATION 1
#define COMPILATION		2
#define INSTALLATION	3
#define FININSTALL		4

/**
  *@author Eric Coquelle
  */

class CWizardStep3 : public QDialog  {
   Q_OBJECT
public: 
  CWizardStep3(QWidget *parent=0, const char *name=0);
 ~CWizardStep3();
 /** Set various parameters for installation */
  void setParametres(const char* conf, const char* confopt, const char* mak, const char* makinst, int typeInstall);	
  /* Start a patch or an install ?
    * 0 is a patch
    * 1 is an install*/
  void setOperation(int op);

protected:
  void initDialog();
  /** Set all leds to green, state=off */
  void initLeds();
  /* Start patching */
  void doPatch();
  /* Start install */
  void doInstall();
  /** recurse and find @param name ,  contained in the directory @param d */
  QString findFiles(QDir d, QString name);

protected slots: // Protected slots
  /** End of the process */
  void endProcess(KProcess* process);
  /** End of the process Install*/
  void endProcessInst(KProcess* process);
  /** Recieve Stdout from the running process */
  void gotStdout(KProcess *proc, char *buffer, int buflen);
  /** Recieve Stderr from the running process */
  void gotStderr(KProcess *proc, char *buffer, int buflen);
  /** Choose if we'll do a patch (op==0) or an install */
  void slotdetermineTypeOperation();


public:
  /* Which file is selected ? */
  QString fichselect;
  /* Where files are located*/
  QString basedir;

private:
  /* The selected file used for patching */
  QString reppatch;
  /* The process for patching */
  KProcess processpath;
  /* The process for installing */
  KShellProcess processinst;	
  /*Some visual indicators*/
  KLed* led1;
  KLed* led2;
  KLed* led3;
  QString config;
  QString configopt;
  QString make;
  QString makeinstall;
  int typeInstallation;
  /* the stage of the installation */
  int operation;
  /* Shall we do a patch or an install? */
  int typeoperation;
  QLabel *label3_0;
  QLabel *label3_1;
  QTextEdit *mleOutput;
  QPushButton *buttonCancel;
  QPushButton *buttonStart;
};

#endif
