/***************************************************************************
                          karchiveurview.cpp  -  description
                             -------------------
    begin                : mer jun 14 00:26:31 CEST 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>

#include <kcursor.h>

// application specific includes
#include "karchiveurview.h"
#include "karchiveur.h"

KarchiveurView::KarchiveurView(QWidget *parent, const char *name) : CListView( parent, name )
{
	addColumn(i18n("Name"));
	addColumn(i18n("Size"));
	addColumn(i18n("Time"));
	addColumn(i18n("Date"));
	addColumn(i18n("Owner"));
	addColumn(i18n("Permissions"));
	addColumn(i18n("Path"));


	setColumnWidth(6,100);
	setColumnAlignment(1,Qt::AlignRight);
	setColumnAlignment(2,Qt::AlignRight);
	setColumnAlignment(3,Qt::AlignRight);
	setColumnAlignment(4,Qt::AlignRight);
	setColumnAlignment(5,Qt::AlignRight);

	setMultiSelection ( true );
	setShowSortIndicator ( true );
	setAcceptDrops ( true );
  connect(this,SIGNAL(dropped (QDropEvent*, QListViewItem*)), this, SLOT(slotDropped (QDropEvent*, QListViewItem*)));
}

KarchiveurView::~KarchiveurView()
{
}

void KarchiveurView::print(QPrinter *pPrinter)
{
	QPainter printpainter;
	const QPixmap *pix=0L;
	QListViewItem* vi;
	QString fichiers;
	int k;

	printpainter.begin(pPrinter);

	// TODO: add your printing code here
	//printpainter.drawText(20,10,fichier->getArchiveName());

	vi = firstChild();
	for ( k = 1; k < childCount()+1; k++ )
	{
		fichiers = QString("%1\t%2\t%3\t%4\t%5\t%6\t%7").arg(vi->text(0)).arg(vi->text(1)).arg(vi->text(2)).arg(vi->text(3)).arg(vi->text(4)).arg(vi->text(5)).arg(vi->text(6));

		pix = vi->pixmap(0);
		if ( pix != NULL )
			printpainter.drawPixmap(10,(k%40+2)*14-pix->height(),*pix);

		printpainter.drawText(30,(k%40+2)*14,fichiers);
		vi = vi->nextSibling();

		if ( (k%40) == 0 )
		pPrinter->newPage();
	}

	printpainter.end();
}

/** Accept any drop event ! */
/*void KarchiveurView::dragEnterEvent(QDragEnterEvent* e)
{
	e->accept(QUriDrag::canDecode(e));
}*/

/** Set or not an alternate background */
void KarchiveurView::setAlternateBackground(bool b)
{
  if(b)
    CListView::setAlternateBackground(KGlobalSettings::alternateBackgroundColor());
  else
    CListView::setAlternateBackground(QColor("invalid"));
}

bool KarchiveurView::acceptDrag(QDropEvent* e) const
{
  //e->accept(QUriDrag::canDecode(e));
  return QUriDrag::canDecode(e);
}

/** A drop occurs */
void KarchiveurView::slotDropped (QDropEvent *drop, QListViewItem */*after*/)
{
  KarchiveurApp *theApp=(KarchiveurApp *) parentWidget();
  theApp->dropEvent(drop);
}

#include "karchiveurview.moc"
