/****************************************************************/
/**                      Class SelfExtractor                                       */
/**              A Self-Extract module for KArchiver                     */
/**                          (c) 2005 Eric Coquelle                              */
/**              eric a.a coquelle a@a gmail _._ com                     */
/****************************************************************/

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.zip.*;
import java.util.*;
import java.text.*;
import java.net.*;


/**
 * Summary description for SelfExtractor
 * Extract all files contained in the Data subfolder of present Jar archive
 */
public class SelfExtractor extends JFrame
{
	// Variables declaration
	private JLabel jLabel1;
	private JLabel jLabel2;
	private JLabel jLabel3;
	private JTextField jTextField2;
	private JButton jButton1;
	private JButton jButton2;
	private JPanel contentPane;
	private  File extractdirectory;
        private ExtractZip extractprocess;
        private ResourceBundle i18nmessages;
	// End of variables declaration


        public SelfExtractor(ResourceBundle messages)
	{
		super();
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                i18nmessages=messages;
                initializeComponent();
		//
		// TODO: Add any constructor code after initializeComponent call
		//

		this.setVisible(true);
	}

	public static ImageIcon getImageIcon(String name) {
		return new ImageIcon(ClassLoader.getSystemResource(name));
	}
 	
 private void initializeComponent()
	{
		jLabel1 = new JLabel();
		jLabel2 = new JLabel();
		jLabel3 = new JLabel();
		jTextField2 = new JTextField();
		jButton1 = new JButton();
		jButton2 = new JButton();
		contentPane = (JPanel)this.getContentPane();

		//
		// jLabel1
		//
                jLabel1.setText(i18nmessages.getString("KArchiver_Autoextract_module"));
                jLabel1.setToolTipText("KArchiver (c) Eric Coquelle (2005)"
                    +"\n Visit http://perso.wanadoo.fr/coquelle");
		//
                //
                jLabel2.setText(i18nmessages.getString("Extract_in"));
		// jLabel3
		//
		jLabel3.setIcon(getImageIcon("Pics/karchiveur_wizard_large.png"));
		//
		// jTextField2
		//
		jTextField2.setText(System.getProperty("user.home"));
		//
		// jButton1
		//
		jButton1.setIcon(getImageIcon("Pics/hi48-app-karchiver-out.png"));
                jButton1.setText(i18nmessages.getString("Extract"));
		jButton1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				jButton1_actionPerformed(e);
			}

		});
		//
		// jButton2
		//
                jButton2.setText(i18nmessages.getString("Browse"));
		jButton2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				jButton2_actionPerformed(e);
			}

		});
		//
		// contentPane
		//
		contentPane.setLayout(null);
		addComponent(contentPane, jLabel1, 10,4,370,38);
		addComponent(contentPane, jLabel2, 144,48,131,30);
		addComponent(contentPane, jLabel3, 5,43,135,176);
		addComponent(contentPane, jTextField2, 144,78,131,31);
		addComponent(contentPane, jButton1, 189,123,136,68);
		addComponent(contentPane, jButton2, 288,78,83,34);
		//
		// SelfExtractor
		//
            this.setTitle(i18nmessages.getString("KArchiver_SelfExtract_archive"));
		this.setLocation(new Point(125, 25));
		this.setSize(new Dimension(390, 256));
		this.setResizable(false);
	}

	/** Add Component Without a Layout Manager (Absolute Positioning) */
	private void addComponent(Container container,Component c,int x,int y,int width,int height)
	{
		c.setBounds(x,y,width,height);
		container.add(c);
	}

	//
	// TODO: Add any appropriate code in the following Event Handling Methods
	//

	private void jButton1_actionPerformed(ActionEvent e)
	{
		extractdirectory=new File(jTextField2.getText());
		if(!extractdirectory.exists())
		{
                  int selectedValue = JOptionPane.showConfirmDialog(SelfExtractor.this,i18nmessages.getString("The_directory")+" "+extractdirectory.getAbsolutePath()+" "+i18nmessages.getString("doesnt_exist_create_it"), i18nmessages.getString("KArchiver_Create_these_directories"), JOptionPane.YES_NO_OPTION);
			if(selectedValue == JOptionPane.NO_OPTION)
				return;
			else
                                if(!extractdirectory.mkdirs())
				{
                                  JOptionPane.showMessageDialog(SelfExtractor.this, i18nmessages.getString("Cannot_create_this_directory"),  i18nmessages.getString("KArchiver_problem"), JOptionPane.ERROR_MESSAGE);
					return;
				}
		}
		
                extractprocess=new ExtractZip(i18nmessages);
		extractprocess.extract(getJarFileName(), extractdirectory, this);
	}

	private void jButton2_actionPerformed(ActionEvent e)
	{
		JFileChooser choiceoutputdir = new JFileChooser();
	
		choiceoutputdir.setDialogType(JFileChooser.OPEN_DIALOG);
		choiceoutputdir.setMultiSelectionEnabled(false);
		choiceoutputdir.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		choiceoutputdir.setDialogTitle(i18nmessages.getString("Select_extraction_directory"));
		
                if (choiceoutputdir.showDialog(SelfExtractor.this, i18nmessages.getString("Select")) == JFileChooser.APPROVE_OPTION) 
		{
			extractdirectory = choiceoutputdir.getSelectedFile();
			jTextField2.setText(extractdirectory.getAbsolutePath());
		}
	}


 private String getJarFileName()
 {
   String currentClassName = this.getClass().getName()+".class";
   URL url = this.getClass().getClassLoader().getSystemResource(currentClassName );
   String localpath = url.toString();
   return localpath.substring("jar:file:".length(), localpath.indexOf("!/"));
 }




























 

//======================================================================//
//======================================================================//
	public static void main(String[] args)
	{
		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);
		try
		{
			UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		}
		catch (Exception ex)
		{
		}

                Locale currentLocale;
                ResourceBundle messages;

                currentLocale = Locale.getDefault();

                messages = ResourceBundle.getBundle("MessagesBundle", currentLocale);
                
                new SelfExtractor(messages);
	}

}
