#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <netinet/ip.h>
#include <pthread.h>
#include <gtk/gtk.h>
#include "proto.h"
#include "connects.h"
#include "karpski.h"
#include "scrupdate.h"

int overall_stats_changed=0;    /* 1 = nhosts changed (MACS)
				 * 2 = nwarnings changed
                                 * 4 = nconnections        
                                 * 8 = ndatagrams        
                                 * 16 = capturing changed
                                 * 32 = 
                                 * 64 = nbytesread changed
                                 * ... reserved          
                                 */                       
int info_stats_changed=0;	/* 1 = hwaddr
				 * 2 = machine addr
				 * 4 = Machine name
				 * 8 = Alias
				 * 16 = Watching
				 * 32 = Role
				 * 64 = vendor
				 * 128 = # conns
				 * 256 = # datagrams
				 * 512 = # bytes read
				 */
t_textitem *first_textitem=NULL, *last_textitem=NULL;
			
extern t_karpski_stats karpski_stats;
extern t_arp_rec *selected_ar;
extern GtkWidget *label1, *label2, *label3, *label4, *nb_read_label, *ndgrams_label;
extern GtkWidget *label_info_1, *label_info_2, *label_info_3, *label_info_4, *label_info_5, *label_info_6, *label_info_7, *label_info_8, *label_info_9, *label_info_10;
extern pthread_mutex_t ConnectMutex, ArpRecMutex, TextItemMutex;

void add_textitem(char *blob, int bloblen, GtkWidget **textbox, char *id)
{
   t_textitem *new_textitem;
   
   if (!blob)
      return;
   
   if ((!(*textbox)) || (!textbox) || (!GTK_IS_TEXT(*textbox)))
      return;
   
   if ((new_textitem=malloc(sizeof(t_textitem)))==NULL)
   {
      perror("malloc textitem");
      exit(1);
   }
   
   if ((new_textitem->blob = malloc(bloblen+1)) == NULL)
   {
      perror("malloc blob");
      exit(1);
   }
   
   bzero(new_textitem->blob, bloblen+1);
   bcopy(blob, new_textitem->blob, bloblen);
   new_textitem->bloblen = bloblen;
   new_textitem->textbox = textbox;
   strcpy(new_textitem->id, id);
   new_textitem->next = NULL;
   
   mutex_enter(TextItemMutex);
   
   if (last_textitem)
   {
      last_textitem->next = new_textitem;
   }
   else
   {
      first_textitem = new_textitem;
   }
   last_textitem = new_textitem;
   
   mutex_exit(TextItemMutex);
   return;
}

void display_textitems()
{
   t_textitem *t_ti, *ti_next;
   GtkWidget *last_text=NULL;
   
   mutex_enter(TextItemMutex);
   
   ti_next = NULL;
   for (t_ti = first_textitem; t_ti; t_ti = ti_next)
   {
      if ((*t_ti->textbox) != last_text)
      {
         if (last_text)
            gtk_text_thaw(GTK_TEXT(last_text));
         gtk_text_freeze(GTK_TEXT(*t_ti->textbox));
         last_text = (*t_ti->textbox);
      }
      if ((*t_ti->textbox))
      {
         if (!GTK_IS_TEXT(*t_ti->textbox))
            printf("Text is whacked!  Report bug to btx@calyx.net\n");
         else
            gtk_text_insert(GTK_TEXT(*t_ti->textbox), NULL, NULL, NULL, t_ti->blob, t_ti->bloblen);
      }
      ti_next = t_ti->next;
      free(t_ti->blob);
      free(t_ti); 
   }
   
   if (last_text)
      gtk_text_thaw(GTK_TEXT(last_text));
   first_textitem = NULL;
   last_textitem = NULL;
   mutex_exit(TextItemMutex);
}

void set_overall_update(int add_no)
{
   overall_stats_changed |= add_no;
}

void reset_overall_update()
{
   overall_stats_changed = 0;
}

void set_info_update(int add_no)
{
   info_stats_changed |= add_no;
}

void reset_info_update()
{
   info_stats_changed = 0;
}

void set_main_list_update(t_arp_rec *t_ar)
{
   t_ar->needs_update = 1;
}

void update_main_list(GtkWidget *main_clist, t_arp_rec *first_arp_rec)
{
   t_arp_rec *t_ar;
   char *texts[NUM_MAIN_CLIST_COLS+1];
   char text[NUM_MAIN_CLIST_COLS][128];
   int i;
   int rowno;

   for (i=0; i<NUM_MAIN_CLIST_COLS; i++)
   {
      texts[i] = text[i];
   }
   texts[NUM_MAIN_CLIST_COLS] = NULL;

   mutex_enter(ArpRecMutex);
   
   gtk_clist_freeze(GTK_CLIST(main_clist));

   for (t_ar = first_arp_rec; t_ar; t_ar = t_ar->next)
   {
      if (t_ar->needs_update)
      {
         strcpy(text[0], (t_ar->watching) ? "Yes" : "No");
         strcpy(text[1], t_ar->hw_addr);
         if ((t_ar->machine_addr[0]) && (t_ar->machine_addr[0] != '?'))
         {
            strcpy(text[2], t_ar->machine_addr);
            strcpy(text[3], t_ar->machine_name);
         }
         else
         {
            strcpy(text[2], "Not avail.");
            strcpy(text[3], "N/A");
      }
         strcpy(text[4], t_ar->vend_str);
         strcpy(text[5], t_ar->methodstr);
         if (t_ar->needs_update == 1)
            gtk_clist_append(GTK_CLIST(main_clist), texts);
         else
         {
            rowno = get_ar_rowno(t_ar, GTK_CLIST(main_clist));
            if (rowno < 0)
               fprintf(stderr, "Error: Row for %s / %s (%d) not found.\n", t_ar->hw_addr, t_ar->machine_addr, t_ar->machine_addr[0]);
            else
               for (i=0;i<6;i++)
                  gtk_clist_set_text(GTK_CLIST(main_clist), rowno, i, text[i]);
         }
         
         t_ar->needs_update=0;
      }
   }                                          

   gtk_clist_thaw(GTK_CLIST(main_clist));
   mutex_exit(ArpRecMutex);
}

void update_overall_stats(GtkWidget *statswindow)
{
   char buf[256];
   
   if (!statswindow)
   {
      overall_stats_changed = 0;
      return;
   }
   
      
   if (overall_stats_changed & 1)
   {
      sprintf(buf, "%-20s %10d", "MACs captured:", karpski_stats.nhosts);
      gtk_label_set(GTK_LABEL(label1), buf);
   }
   if (overall_stats_changed & 2)
   {
      sprintf(buf, "%-20s %10d", "Number warnings:", karpski_stats.nwarnings);
      gtk_label_set(GTK_LABEL(label3), buf);
   }
   if (overall_stats_changed & 4)
   {
      sprintf(buf, "%-20s %10d", "Number connections:", karpski_stats.nconnections);
      gtk_label_set(GTK_LABEL(label4), buf);
   }
   if (overall_stats_changed & 8)
   {
      sprintf(buf, "%-20s %10d", "Num. Datagrams:", karpski_stats.ndatagrams);
      gtk_label_set(GTK_LABEL(ndgrams_label), buf);
   }
   if (overall_stats_changed & 16)
   {
      sprintf(buf, "%-20s %10s", "Caoturing data:", "Yes");
      gtk_label_set(GTK_LABEL(label2), buf);
   }
   if (overall_stats_changed & 32)
   {
      sprintf(buf, "%-20s %10d", "Number connections:", karpski_stats.nconnections);
      gtk_label_set(GTK_LABEL(label4), buf);
   }
   if (overall_stats_changed & 64)
   {
      sprintf(buf, "%-20s %10ld", "Bytes read:", karpski_stats.nbytesread);
      gtk_label_set(GTK_LABEL(nb_read_label), buf);
   }
   
   overall_stats_changed = 0;
}

void update_info_stats(GtkWidget *infowindow)
{
   char buf[256];
   
   if (!infowindow)
   {
      info_stats_changed = 0;
      return;
   }
   
   mutex_enter(ArpRecMutex);
   
   if (info_stats_changed & 1)
   {
      sprintf(buf, "%-20s %20s", "HW Addr::", selected_ar->hw_addr);
      gtk_label_set(GTK_LABEL(label_info_1), buf);
   }   
   if (info_stats_changed & 2)
   {
      sprintf(buf, "%-20s %20s", "Machine addr:", (selected_ar->machine_addr[0]) ? selected_ar->machine_addr : "Not avail.");
      gtk_label_set(GTK_LABEL(label_info_2), buf);
   }   
   if (info_stats_changed & 4)
   {
      sprintf(buf, "%-20s %20s", "Machine name:", (selected_ar->machine_name[0]) ? selected_ar->machine_name : "N/A");
      gtk_label_set(GTK_LABEL(label_info_3), buf);
   }   
   if (info_stats_changed & 8)
   {
      sprintf(buf, "%-20s %20s", "Alias:", selected_ar->alias);
      gtk_label_set(GTK_LABEL(label_info_4), buf);
   }   
   if (info_stats_changed & 16)
   {
      sprintf(buf, "%-20s %20s", "Watching:", selected_ar->watching ? "Yes" : "No");
      gtk_label_set(GTK_LABEL(label_info_5), buf);
   }   
   if (info_stats_changed & 32)
   {
      sprintf(buf, "%-20s %20s", "Possible role:", selected_ar->role);
      gtk_label_set(GTK_LABEL(label_info_6), buf);
   }   
   if (info_stats_changed & 64)
   {
      sprintf(buf, "%-20s %20s", "NIC Vendor:", selected_ar->vend_str);
      gtk_label_set(GTK_LABEL(label_info_7), buf);
   }   
   if (info_stats_changed & 128)
   {
      sprintf(buf, "%-20s %20d", "Num. connections:", selected_ar->nconns);
      gtk_label_set(GTK_LABEL(label_info_8), buf);
   }   
   if (info_stats_changed & 256)
   {
      sprintf(buf, "%-20s %20d", "Num. datagrams:", selected_ar->ndgrams);
      gtk_label_set(GTK_LABEL(label_info_9), buf);
   }   
   if (info_stats_changed & 512)
   {
      sprintf(buf, "%-20s %20ld", "Num. bytes:", selected_ar->nbytes);
      gtk_label_set(GTK_LABEL(label_info_10), buf);
   }   
   
   info_stats_changed = 0;
   mutex_exit(ArpRecMutex);
}
