/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Laurent Montel : montel@kde.org                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATUTILS_H_
#define _KATUTILS_H_

#include "kat_export.h"

class QString;
class KAboutData;

KAT_EXPORT void addSeparators( QString& s );
KAT_EXPORT QString katConvertSeconds( unsigned int seconds );
KAT_EXPORT QPixmap loadMenuIconEnabled( const QString& );
KAT_EXPORT QPixmap loadToolbarIconEnabled( const QString& );
KAT_EXPORT QPixmap loadToolbarIconDisabled( const QString& );
KAT_EXPORT QPixmap loadLargeIconEnabled( const QString& );
KAT_EXPORT QIconSet createToolbarIconSet( const QString& );

KAT_EXPORT KAboutData katAboutData();

#endif // _KATUTILS_H_
