/*
 * preferencesdialog.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PREFERENCESDIALOGL_HH__
#define __PREFERENCESDIALOGL_HH__

#include <gtkmm/dialog.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/box.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/notebook.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/comboboxtext.h>
#include <gtkmm/frame.h>
#include <gtkmm/colorbutton.h>
#include <gtkmm/table.h>
#include <gtkmm/fontbutton.h>
#include "conf.hh"

class PreferencesDialog {
public:
  PreferencesDialog(Conf&, Encodings&);
  ~PreferencesDialog();
  bool run();
  sigc::signal<void> signal_apply_clicked;

private:
  void general();
  void interface();
  void tabs();
  void editor();
  void encodings();
  void file_save();
#ifdef HAVE_SPELL
  void spell_checker();
#endif
#ifdef ENABLE_PRINT
  void print();
#endif
  void dictionary();
  void multipress();
  void remote();
  void advanced();

  void apply_clicked_cb() {
    repopulate_conf();
    signal_apply_clicked.emit();
  }
  void repopulate_conf();

  void selection_signal_changed_cb();

  void undo_toggled_cb() { undono.set_sensitive(undo.get_active()); }
  void undo_closed_toggled_cb() { undo_closedno.set_sensitive(undo_closed.get_active()); }
  void recent_toggled_cb() { recentno.set_sensitive(recent.get_active()); }
  void toolbar_toggled_cb() { toolbartype.set_sensitive(toolbar.get_active()); }
  void showtabs_toggled_cb() { tabspos.set_sensitive(showtabs.get_active()); }
  void linenumbers_toggled_cb() { linenumbers_pos.set_sensitive(linenumbers.get_active()); }
  void default_font_toggled_cb() { font.set_sensitive(!default_font.get_active()); }
  void locale_enc_toggled_cb() { saved_enc.set_sensitive(!locale_enc.get_active()); }
  void backup_toggled_cb() { backup_ext.set_sensitive(backup.get_active()); }
  //  void spell_check_toggled_cb() { misspelled.set_sensitive(spell_check.get_active()); }
#ifdef ENABLE_PRINT
  void gui_show_advanced_toggled_cb() { print_frame.set_sensitive(gui_show_advanced.get_active()); }
#endif
  void dict_toggled_cb() { dictionary_table.set_sensitive(dict.get_active());  }
  void savewinpos_toggled_cb() {
    bool active = savewinpos.get_active();
    size.set_sensitive(active);
    pos.set_sensitive(active);
  }

  void list_dicts_clicked_cb();

  Conf& _conf;
  Encodings& _enc;

  Gtk::Dialog dialog;
  Gtk::ScrolledWindow sw;
  Gtk::TreeView treeview;
  Glib::RefPtr<Gtk::TreeSelection> selection;
  Gtk::TreeModelColumn<int> number;
  Gtk::TreeModelColumn<Glib::ustring> section;
  Gtk::TreeModelColumnRecord record;
  Glib::RefPtr<Gtk::ListStore> store;
  Gtk::HBox box;
  Gtk::Notebook notebook;
  Gtk::Button apply;

  Gtk::VBox _general, _interface, _tabs, _editor, _encodings, _file_save, _dictionary, _multipress, _remote, _advanced;
#ifdef HAVE_SPELL
  Gtk::VBox _spell_checker;
#endif
#ifdef ENABLE_PRINT
  Gtk::VBox _print;
#endif

  // General.
  Gtk::CheckButton undo, undo_closed;
  Gtk::Table general_table1, general_table2;
  Gtk::Label undo_label, exec_label, undo_closed_label;
  Gtk::Adjustment undono_adj, exec_adj, undo_closed_adj;
  Gtk::SpinButton undono, exec_cmd_size, undo_closedno;

  // Interface
  Gtk::CheckButton toolbar, extended_toolbar, statusbar, recent, showclose, extra_buttons;
  Gtk::Adjustment recentno_adj;
  Gtk::SpinButton recentno;
  Gtk::Label recentno_label, toolbartype_label;
  Gtk::Table interface_table;
  Gtk::ComboBoxText toolbartype;

  // Tabs
  Gtk::CheckButton showtabs, tabsmenu, scrolltabs;
  Gtk::Label tabspos_label, readonly_label, modified_label, normal_label;
  Gtk::ComboBoxText tabspos;
  Gtk::Table tabs_table;
  Gtk::ColorButton readonly, modified, normal;

  // Editor
  Gtk::CheckButton textwrap, linenumbers, default_font;
  Gtk::FontButton font;
  Gtk::ComboBoxText linenumbers_pos;
  Gtk::Frame font_frame;
  Gtk::Label linenumbers_label;
  Gtk::HBox ed_box1;
  Gtk::VBox ed_box2;
  Gtk::HBox ed_box3;
  Gtk::SpinButton tab_width;
  Gtk::Adjustment tab_width_adj;
  Gtk::Label tab_width_label;
#ifdef ENABLE_HIGHLIGHT
  Gtk::CheckButton highlight_auto;
#endif

  // Encodings
  Gtk::ComboBoxText save_enc, saved_enc;
  Gtk::CheckButton locale_enc;
  Gtk::Label saved_enc_label, save_enc_label;
  Gtk::HBox enc_box1, enc_box2;
  Gtk::VBox enc_box3;
  Gtk::Frame save_frame, saved_frame;

  // File Save.
  Gtk::CheckButton backup;
  Gtk::Entry backup_ext;
  Gtk::Label backup_label;
  Gtk::HBox fs_box1;

#ifdef HAVE_SPELL
  // Spell Checker
  Gtk::CheckButton spell_check;
  Gtk::ComboBoxText default_dict;
  Gtk::Label default_dict_label;//, misspelled_label;
  Gtk::HBox /*sc_box1,*/ sc_box2;
  //  Gtk::ColorButton misspelled;
#endif

#ifdef ENABLE_PRINT
  // Print
  Gtk::Label print_label, dpi_x_label, dpi_y_label;
  Gtk::FontButton print_font;
  Gtk::CheckButton gui_show_advanced;
  Gtk::Frame print_frame;
  Gtk::HBox p_box2;
  Gtk::Adjustment dpi_x_adj, dpi_y_adj;
  Gtk::SpinButton dpi_x, dpi_y;
  Gtk::Table print_table;
#endif

  // Dictionary
  Gtk::CheckButton dict;
  Gtk::Label dict_host_label, dict_port_label, dict_timeout_label, dict_name_label;
  Gtk::Entry dict_host;
  Gtk::SpinButton dict_port, dict_timeout;
  Gtk::Adjustment dict_port_adj, dict_timeout_adj;
  Gtk::Button list_dicts;
  Gtk::Table dictionary_table;
  // The tree view.
  Glib::RefPtr<Gtk::TreeSelection> dict_selection;
  Gtk::TreeView dicts;
  Gtk::TreeModelColumn<Glib::ustring> dict_name;
  Gtk::TreeModelColumn<Glib::ustring> dict_description;
  Gtk::TreeModelColumnRecord dict_record;
  Glib::RefPtr<Gtk::ListStore> dict_store;
  Gtk::ScrolledWindow dict_sw;

  // Multipress.
  Gtk::Adjustment multipress_timeout_adj;
  Gtk::SpinButton multipress_timeout;
  Gtk::HBox m_box1;
  Gtk::Label multipress_timeout_l;

  // Remote.
  Gtk::CheckButton open_location_to_active;
  Gtk::SpinButton locations_size;
  Gtk::Adjustment locations_size_adj;
  Gtk::Label locations_size_label, remote_command_label;
  Gtk::HBox r_box1, r_box2;
  Gtk::Entry remote_command;

  // Advanced
  Gtk::CheckButton saveonexit, savewinpos;
  Gtk::Frame pos, size;
  Gtk::Label x_label, y_label, w_label, h_label;
  Gtk::Adjustment x_adj, y_adj, w_adj, h_adj;
  Gtk::Table pos_table, size_table;
  Gtk::SpinButton x, y, w, h;
};

#endif /* __PREFERENCESDIALOGL_HH__ */
